package cn.smarthse.modules.health.entity.work.train;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

@Table(name = "train_file")
public class TrainFile implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 资料编号
     */
    private String no;

    /**
     * 资料名称
     */
    private String name;

    /**
     * 附件id
     */
    @Column(name = "file_Id")
    private String fileId;

    /**
     * 附件地址
     */
    @Column(name = "file_url")
    private String fileUrl;

    /**
     * 资料大类型（1.培训教材，2.培训考核试卷，3培训素材）
     */
    private Byte type;

    /**
     * 资料小类型编号
     */
    @Column(name = "file_type")
    private Long fileType;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;
    /**
     * 创建人姓名
     */
    @Transient
    private String createName;
    /**
     * 修改人姓名
     */
    @Transient
    private String updateName;

    /**
     * 类型名称
     */
    @Transient
    private String typeName;
    
    /**
     * 不在这些id里面
     */
    @Transient
    private String notInIds;

	private static final long serialVersionUID = 1L;
    
    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取资料编号
     *
     * @return no - 资料编号
     */
    public String getNo() {
        return no;
    }

    /**
     * 设置资料编号
     *
     * @param no 资料编号
     */
    public void setNo(String no) {
        this.no = no == null ? null : no.trim();
    }

    /**
     * 获取资料名称
     *
     * @return name - 资料名称
     */
    public String getName() {
        return name;
    }

    /**
     * 设置资料名称
     *
     * @param name 资料名称
     */
    public void setName(String name) {
        this.name = name == null ? null : name.trim();
    }

    /**
     * 获取附件id
     *
     * @return file_Id - 附件id
     */
    public String getFileId() {
        return fileId;
    }

    /**
     * 设置附件id
     *
     * @param fileId 附件id
     */
    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    /**
     * 获取附件地址
     *
     * @return file_url - 附件地址
     */
    public String getFileUrl() {
        return fileUrl;
    }

    /**
     * 设置附件地址
     *
     * @param fileUrl 附件地址
     */
    public void setFileUrl(String fileUrl) {
        this.fileUrl = fileUrl == null ? null : fileUrl.trim();
    }

    /**
     * 获取资料大类型（1.培训教材，2.培训考核试卷，3培训素材）
     *
     * @return type - 资料大类型（1.培训教材，2.培训考核试卷，3培训素材）
     */
    public Byte getType() {
        return type;
    }

    /**
     * 设置资料大类型（1.培训教材，2.培训考核试卷，3培训素材）
     *
     * @param type 资料大类型（1.培训教材，2.培训考核试卷，3培训素材）
     */
    public void setType(Byte type) {
        this.type = type;
    }

    /**
     * 获取资料小类型编号
     *
     * @return file_type - 资料小类型编号
     */
    public Long getFileType() {
        return fileType;
    }

    /**
     * 设置资料小类型编号
     *
     * @param fileType 资料小类型编号
     */
    public void setFileType(Long fileType) {
        this.fileType = fileType;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }
    
    public String getCreateName() {
		return createName;
	}

	public void setCreateName(String createName) {
		this.createName = createName;
	}

	public String getUpdateName() {
		return updateName;
	}

	public void setUpdateName(String updateName) {
		this.updateName = updateName;
	}

	public String getTypeName() {
		return typeName;
	}

	public void setTypeName(String typeName) {
		this.typeName = typeName;
	}

	public String getNotInIds() {
		return notInIds;
	}

	public void setNotInIds(String notInIds) {
		this.notInIds = notInIds;
	}
	
}