package cn.smarthse.modules.health.entity.work.train;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Table(name = "train_attend")
@Data
public class TrainAttend implements Serializable {

    private static final long serialVersionUID = -7029143713983442279L;

    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 培训ID
     */
    @Column(name = "train_id")
    private Long trainId;

    /**
     * 人员信息ID
     */
    @Column(name = "staff_id")
    private Long staffId;

    /**
     * 人员名称
     */
    @Column(name = "staff_name")
    private String staffName;

    /**
     * 人员岗位id
     */
    @Column(name = "workrole_Id")
    private Long workroleId;

    /**
     * 人员岗位
     */
    @Column(name = "workrole_name")
    private String workroleName;

    /**
     * 人员所在部门id
     */
    @Column(name = "dept_id")
    private Long deptId;

    /**
     * 人员所在部门
     */
    @Column(name = "dept_name")
    private String deptName;

    /**
     * 考试状态, 0:未考试 1:及格 2：不及格
     */
    @Column(name = "exam_status")
    private Integer examStatus;

    /**
     * 考试 得分
     */
    @Column(name = "exam_score")
    private Integer examScore;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;
    /**
     * 是否参与培训（0-未参与，1-参加培训培训）
     */
    @Column(name = "is_train")
    private Boolean isTrain;

    @Transient
    private Long passScore; //及格成绩

    @Transient
    private Integer learnState; //培训状态

    @Transient
    private Boolean onlineTrain; //在线培训

    @Transient
    private Boolean onlineTest; //在线考试

    @Transient
    private List<Long> deptIds; // 部门集合

    @Transient
    private Date startDate; // 开始时间

    @Transient
    private Date endDate; // 结束时间
}