package cn.smarthse.modules.health.entity.work.train;

import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.enums.train.TrainOnLineEnum;
import cn.smarthse.modules.health.enums.train.TrainHsTypeEnum;
import cn.smarthse.modules.health.enums.train.TrainWayEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 《》
 *
 * @author XiaoYi(肖奕)
 * @Project: smarthse-facade
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <人员培训信息>
 * @JDK version used:      <JDK1.7>
 * @since 2017年8月11日-下午2:46:50
 */
@Data
public class StaffTrainInfo implements Serializable {

    private static final long serialVersionUID = -1024267945363958248L;

    private Long tid;        //培训id
    private String no;        //培训类型
    private String type;    //培训类型
    private String typeName; //培训类型名称
    private Byte way;        //培训方式(1.内部，2.外部）
    private String wayDesc; //培训方式描述
    private Date trainTime;    //培训时间
    private String name;    //课程名称
    private String classCount; //课时
    private Boolean needOnlineTrain;
    private Long passScore; //及格成绩
    private Long testScore; //考试成绩
    private Long staffId;
    private Long creditTime; //学时

    /**
     * 线上线下(1.线下，2线上)
     */
    private Byte onLine;

    /**
     * 岗位id
     */
    private Long staffWorkRoleId;

    /**
     * 岗位名
     */
    private String staffWorkroleName;

    /**
     * 部门id
     */
    private Long staffDeptId;

    /**
     * 部门名
     */
    private String staffDeptName;

    /**
     * 人员姓名
     */
    private String staffName;

    /**
     * 工号
     */
    private String workNo;

    /**
     * 培训次数
     */
    private Integer trainCount;

    /**
     * 完成时间
     */
    private Date completedTime;

    /**
     * 培训类型：1:职业卫生；2:安全
     * <p>
     * 以逗号分隔
     */
    private String hsType;

    /**
     * 培训类型名称
     */
    private String hsTypeName;

    /**
     * 方式名称
     * <p>
     * 内部、线上；内部、线下；外部、线上；外部、线下
     */
    private String wayAndOnLine;

    public void setHsTypeName(String hsType) {
        StringBuilder hsTypeName2 = new StringBuilder();
        if (!StringUtils.isEmpty(hsType)) {
            List<Integer> types = StringUtils.parseToIntegerList(hsType, ",");
            for (int i = 0; i < types.size(); i++) {
                hsTypeName2.append(TrainHsTypeEnum.getName(types.get(i)));
                if (i < types.size() - 1) {
                    hsTypeName2.append(" | ");
                }
            }
        }
        this.hsTypeName = hsTypeName2.toString();
    }

    public void setWayAndOnLine(Byte way, Byte onLine) {
//        if (hsType == null) {
//            this.wayAndOnLine = this.getWay() + "、" + TrainOnLineEnum.getName(onLine);
//        } else {
        this.wayAndOnLine = TrainWayEnum.getName(way) + "、" + TrainOnLineEnum.getName(onLine);
//        }
    }
}
