package cn.smarthse.modules.health.entity.work.train;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 教育培训查询类
 *
 * @author XiaoYi(肖奕)
 * @Project: smarthse-facade
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7>
 * @since 2017年8月11日-下午2:58:08
 */
@Data
public class QueryTrainParam implements Serializable {

    private static final long serialVersionUID = 2816853791968567325L;

    private Long cid;
    private Long staffid;
    private String name;
    private Byte type;// 培训类型
    private String no;// 培训编号
    private Long workroleId;// 岗位工种
    private String staffName;// 人员姓名
    private Boolean isValid;
    private Boolean isFinish;
    private String keyword;
    private String staffIds;
    private String cids;

    /**
     * 部门id集合
     */
    private List<Long> deptIds;

    /**
     * 岗位id集合
     */
    private List<Long> workRoleIds;

    /**
     * 查询开始时间
     */
    private Date beginTime;

    /**
     * 查询结束时间
     */
    private Date endTime;

    /**
     * 人员培训记录列表导出的表头
     * <p>
     * {"工号|workNo", "用户姓名|staffName", "车间|staffDeptName", "岗位|staffWorkroleName", "课程名称|name", "类型|hsTypeName", "方式|wayAndOnLine;", "学时|classCount", "完成时间|completedTime"}
     */
    private String[] colums;

    /**
     * 要导出的人员id集合
     */
    private List<Long> staffIdss;

    private Integer year;

    private Integer month;
}