package cn.smarthse.modules.health.entity.work.thirdtime;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

@Table(name = "ts_project_study")
public class TsProjectStudy implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 项目ID
     */
    @Column(name = "ts_id")
    private Long tsId;

    /**
     * 自行编制
     */
    @Column(name = "self_edit")
    private Boolean selfEdit;

    /**
     * 职业病危害预评价报告编制单位
     */
    @Column(name = "occ_pre_report_cid")
    private Long occPreReportCid;

    /**
     * 职业病危害预评价委托书(File.id)
     */
    @Column(name = "occ_pre_proxy_fid")
    private String occPreProxyFid;

    /**
     * 报告评审时间
     */
    @Column(name = "report_review_time")
    private Date reportReviewTime;

    /**
     * 1一般  2较重    3严重
     */
    @Column(name = "occ_type")
    private Byte occType;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取项目ID
     *
     * @return ts_id - 项目ID
     */
    public Long getTsId() {
        return tsId;
    }

    /**
     * 设置项目ID
     *
     * @param tsId 项目ID
     */
    public void setTsId(Long tsId) {
        this.tsId = tsId;
    }

    /**
     * 获取自行编制
     *
     * @return self_edit - 自行编制
     */
    public Boolean getSelfEdit() {
        return selfEdit;
    }

    /**
     * 设置自行编制
     *
     * @param selfEdit 自行编制
     */
    public void setSelfEdit(Boolean selfEdit) {
        this.selfEdit = selfEdit;
    }

    /**
     * 获取职业病危害预评价报告编制单位
     *
     * @return occ_pre_report_cid - 职业病危害预评价报告编制单位
     */
    public Long getOccPreReportCid() {
        return occPreReportCid;
    }

    /**
     * 设置职业病危害预评价报告编制单位
     *
     * @param occPreReportCid 职业病危害预评价报告编制单位
     */
    public void setOccPreReportCid(Long occPreReportCid) {
        this.occPreReportCid = occPreReportCid;
    }

    /**
     * 获取职业病危害预评价委托书(File.id)
     *
     * @return occ_pre_proxy_fid - 职业病危害预评价委托书(File.id)
     */
    public String getOccPreProxyFid() {
        return occPreProxyFid;
    }

    /**
     * 设置职业病危害预评价委托书(File.id)
     *
     * @param occPreProxyFid 职业病危害预评价委托书(File.id)
     */
    public void setOccPreProxyFid(String occPreProxyFid) {
        this.occPreProxyFid = occPreProxyFid == null ? null : occPreProxyFid.trim();
    }

    /**
     * 获取报告评审时间
     *
     * @return report_review_time - 报告评审时间
     */
    public Date getReportReviewTime() {
        return reportReviewTime;
    }

    /**
     * 设置报告评审时间
     *
     * @param reportReviewTime 报告评审时间
     */
    public void setReportReviewTime(Date reportReviewTime) {
        this.reportReviewTime = reportReviewTime;
    }

    /**
     * 获取1一般  2较重    3严重
     *
     * @return occ_type - 1一般  2较重    3严重
     */
    public Byte getOccType() {
        return occType;
    }

    /**
     * 设置1一般  2较重    3严重
     *
     * @param occType 1一般  2较重    3严重
     */
    public void setOccType(Byte occType) {
        this.occType = occType;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }
}