package cn.smarthse.modules.health.entity.work.thirdtime;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.*;

@Table(name = "ts_project_start")
public class TsProjectStart implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 项目ID
     */
    @Column(name = "ts_id")
    private Long tsId;

    /**
     * 项目地址
     */
    @Column(name = "pro_address")
    private String proAddress;

    /**
     * 项目总投资
     */
    @Column(name = "pro_total_invest")
    private BigDecimal proTotalInvest;

    /**
     * 项目联系人
     */
    @Column(name = "pro_contact_sid")
    private Long proContactSid;

    /**
     * 项目联系方式
     */
    @Column(name = "pro_contact_tel")
    private String proContactTel;

    /**
     * 立项批复文件
     */
    @Column(name = "approval_documents")
    private String approvalDocuments;

    /**
     * 纸质版存放位置
     */
    @Column(name = "paper_location")
    private String paperLocation;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取项目ID
     *
     * @return ts_id - 项目ID
     */
    public Long getTsId() {
        return tsId;
    }

    /**
     * 设置项目ID
     *
     * @param tsId 项目ID
     */
    public void setTsId(Long tsId) {
        this.tsId = tsId;
    }

    /**
     * 获取项目地址
     *
     * @return pro_address - 项目地址
     */
    public String getProAddress() {
        return proAddress;
    }

    /**
     * 设置项目地址
     *
     * @param proAddress 项目地址
     */
    public void setProAddress(String proAddress) {
        this.proAddress = proAddress == null ? null : proAddress.trim();
    }

    /**
     * 获取项目总投资
     *
     * @return pro_total_invest - 项目总投资
     */
    public BigDecimal getProTotalInvest() {
        return proTotalInvest;
    }

    /**
     * 设置项目总投资
     *
     * @param proTotalInvest 项目总投资
     */
    public void setProTotalInvest(BigDecimal proTotalInvest) {
        this.proTotalInvest = proTotalInvest;
    }

    /**
     * 获取项目联系人
     *
     * @return pro_contact_sid - 项目联系人
     */
    public Long getProContactSid() {
        return proContactSid;
    }

    /**
     * 设置项目联系人
     *
     * @param proContactSid 项目联系人
     */
    public void setProContactSid(Long proContactSid) {
        this.proContactSid = proContactSid;
    }

    /**
     * 获取项目联系方式
     *
     * @return pro_contact_tel - 项目联系方式
     */
    public String getProContactTel() {
        return proContactTel;
    }

    /**
     * 设置项目联系方式
     *
     * @param proContactTel 项目联系方式
     */
    public void setProContactTel(String proContactTel) {
        this.proContactTel = proContactTel == null ? null : proContactTel.trim();
    }

    /**
     * 获取立项批复文件
     *
     * @return approval_documents - 立项批复文件
     */
    public String getApprovalDocuments() {
        return approvalDocuments;
    }

    /**
     * 设置立项批复文件
     *
     * @param approvalDocuments 立项批复文件
     */
    public void setApprovalDocuments(String approvalDocuments) {
        this.approvalDocuments = approvalDocuments == null ? null : approvalDocuments.trim();
    }

    /**
     * 获取纸质版存放位置
     *
     * @return paper_location - 纸质版存放位置
     */
    public String getPaperLocation() {
        return paperLocation;
    }

    /**
     * 设置纸质版存放位置
     *
     * @param paperLocation 纸质版存放位置
     */
    public void setPaperLocation(String paperLocation) {
        this.paperLocation = paperLocation == null ? null : paperLocation.trim();
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }
}