package cn.smarthse.modules.health.entity.work.thirdtime;

import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.health.enums.thirdtime.TsProjectSimpleStatusEnum;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.util.StringUtil;
import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.util.*;

/**
 * 建设项目 - 简化版
 * @author wujiacheng
 * @date 2022-7-22
 */
@Table(name = "ts_project_simple")
public @Data
class TsProjectSimple implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 项目名称
     */
    @Column(name = "project_name")
    private String projectName;

    /**
     * 同步的时候生成，唯一键
     */
    @Column(name = "project_code")
    private String projectCode;

    /**
     * 立项时间
     */
    @Column(name = "project_time")
    private Date projectTime;

    /**
     * 竣工时间
     */
    @Column(name = "project_finish_time")
    private Date projectFinishTime;

    /* 职业病危害预评价 */
    /**
     * 评价机构ID
     * 弃用该字段
     */
    @Column(name = "harm_eval_org_id")
    private Long harmEvalOrgId;

    /**
     * 评价机构名称
     * 弃用该字段
     */
    @Column(name = "harm_eval_org_name")
    private String harmEvalOrgName;

    /**
     * 报告编号
     */
    @Column(name = "harm_no")
    private String harmNo;

    /**
     * 评价完成时间
     * 弃用该字段
     */
    @Column(name = "harm_eval_finish_time")
    private Date harmEvalFinishTime;

    /* 职业病防护设施设计专篇 */
    /**
     * 设计机构ID
     */
    @Column(name = "design_org_id")
    private Long designOrgId;

    /**
     * 设计机构名称
     */
    @Column(name = "design_org_name")
    private String designOrgName;

    /**
     * 报告编号
     */
    @Column(name = "design_no")
    private String designNo;

    /**
     * 设计完成时间
     */
    @Column(name = "design_finish_time")
    private Date designFinishTime;

    /* 职业病危害控制效果评价 */
    /**
     * 评价机构ID
     * 弃用该字段
     */
    @Column(name = "con_eval_org_id")
    private Long conEvalOrgId;

    /**
     * 评价机构名称
     * 弃用该字段
     */
    @Column(name = "con_eval_org_name")
    private String conEvalOrgName;

    /**
     * 报告编号
     */
    @Column(name = "control_no")
    private String controlNo;

    /**
     * 评价完成时间
     * 弃用该字段
     */
    @Column(name = "con_finish_time")
    private Date conFinishTime;

    /**
     * 1 终止， 0项目正常（默认）
     */
    @Column(name = "is_close")
    private Boolean isClose;

    /**
     * 终止原因
     */
    @Column(name = "close_reason")
    private String closeReason;

    /**
     * 是否完成
     * 1： 是    0： 否
     */
    @Column(name = "is_finish")
    private Boolean isFinish;

    /**
     * 是否作废
     * 0： 是    1： 否
     */
    @Column(name = "is_void")
    private Boolean isVoid = false;

    /**
     * 备注
     */
    @Column(name = "remark")
    private String remark;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建人对应的部门
     */
    @Column(name = "org_id")
    private String orgId;

    @Column(name = "status")
    private Byte status;
    @Column(name = "risk_type")
    private Byte riskType;

    //承诺书id
    @Column(name = "commitment")
    private Long commitment;
    //佐证材料
    @Column(name = "evidence")
    private String evidence;

    //合理缺项  1-不存在职业病危害因素，无需开展“三同时” / 2- 本项目未进行真实建设', / 3- 补码项目 “补码项目为：三同时项目2021年前已建成，2021年以后重新赋码的项目”；
    private Byte missingItem;

    private Byte evalState;
    private Byte designState;
    private Byte controlState;

    //去年进行中三同时项目选择状态存档
    private Byte evalStateOld;
    private Byte designStateOld;
    private Byte controlStateOld;
    //数据来源 1-新增  2-isr同步数据
    private Byte dataSource;

    private Long harmEvalOrgId1;
    private String harmEvalOrgName1;
    private Date harmEvalFinishTime1;
    private Long harmEvalOrgId2;
    private String harmEvalOrgName2;
    private Date harmEvalFinishTime2;
    private Long conEvalOrgId1;
    private String conEvalOrgName1;
    private Date conFinishTime1;
    private Long conEvalOrgId2;
    private String conEvalOrgName2;
    private Date conFinishTime2;


    private String evalEvidenceId1;
    private String evalEvidenceId2;
    private String designEvidenceId;
    private String controlEvidenceId1;
    private String controlEvidenceId2;

    //null-正常三同时  0-等待关联的三同时 1-已关联的三同时
    private Byte newCompanyGuideRelated;

    //建设规模内容
    @Transient
    private String scaleContent;

    @Transient
    private SysFileModel evalEvidenceFile1;
    @Transient
    private SysFileModel evalEvidenceFile2;
    @Transient
    private SysFileModel designEvidenceFile;
    @Transient
    private SysFileModel controlEvidenceFile1;
    @Transient
    private SysFileModel controlEvidenceFile2;



    @Transient
    private String companyName;

    //承诺书
    @Transient
    private SysFileModel file;
    //作证材料
    @Transient
    private List<SysFileModel> evidenceFileList;

    //作证材料(json字符串)
    @Transient
    private String evidenceFileJsonString;

    // 退回原因
    @Transient
    private String reason;

    // 关键因素画像id
    @Transient
    private Long keyFactoryId;

    public String getEvidenceFileJsonString() {
        if (StringUtil.isEmpty(evidenceFileJsonString))
            evidenceFileJsonString= JSON.toJSONString(new ArrayList<>());
        return evidenceFileJsonString;
    }

    public void setEvidenceFileJsonString(String evidenceFileJsonString) {
        this.evidenceFileJsonString = evidenceFileJsonString;
    }

    public Integer getFillingType(){
        if (missingItem!=null)
            return 4;
        return null;
    }

    public String getFillingReason(){
        if (missingItem!=null){
            if (missingItem==1) return "不存在职业病危害因素，无需开展“三同时”";
            if (missingItem==2) return "本项目未进行真实建设";
            if (missingItem==3) return "补码项目为：三同时项目2021年前已建成，2021年以后重新赋码的项目";
            if (missingItem==4) return "建设项目地址不在境内";
        }

        return "";
    }

    public String getRiskTypeStr(){
        if (riskType!=null){
            if (riskType==1) return "严重";
            if (riskType==2) return "一般";
        }

        return "/";
    }

    public String getStatusName() {
        String name="草稿";
        for (TsProjectSimpleStatusEnum value : TsProjectSimpleStatusEnum.values()) {
            if (value.getCode().equals(status)) {
                name = value.getName();
            }
        }
        return name;
    }

    public String getProjectTimeStr() {
        if (Objects.isNull(projectTime)) return "";
        return DateUtil.format(projectTime, "yyyy-MM-dd");
    }
    public String getUpdateDataStr() {
        if (Objects.isNull(updateDate)) return "";
        return DateUtil.format(updateDate, "yyyy-MM-dd");
    }

    public String getProjectFinishTimeStr() {
        if (Objects.isNull(projectFinishTime)) return "";
        return DateUtil.format(projectFinishTime, "yyyy-MM-dd");
    }

    public String getHarmEvalFinishTime1Str() {

        if (Objects.isNull(harmEvalFinishTime1)) {
            if (missingItem!=null) return "无需开展";
            else return "/";
        }
        return DateUtil.format(harmEvalFinishTime1, "yyyy-MM-dd");
    }

    public String getHarmEvalFinishTime2Str() {
        if (Objects.isNull(harmEvalFinishTime2)) return "";
        return DateUtil.format(harmEvalFinishTime2, "yyyy-MM-dd");
    }

    public String getDesignFinishTimeStr() {

        if (Objects.isNull(designFinishTime)) {
            if (missingItem!=null) return "无需开展";
            else return "/";
        }
        return DateUtil.format(designFinishTime, "yyyy-MM-dd");
    }

    public String getConFinishTime1Str() {

        if (Objects.isNull(conFinishTime1)) {
            if (missingItem!=null) return "无需开展";
            else return "/";
        }
        return DateUtil.format(conFinishTime1, "yyyy-MM-dd");
    }

    public String getConFinishTime2Str() {
        if (Objects.isNull(conFinishTime2)) return "";
        return DateUtil.format(conFinishTime2, "yyyy-MM-dd");
    }

    public String getDesignOrgName() {

        if (StringUtil.isEmpty(designOrgName))
            if (missingItem!=null) return "无需开展";
            else return "/";
        return designOrgName;
    }

    public String getHarmEvalOrgName1() {
        if (StringUtil.isEmpty(harmEvalOrgName1))
            if (missingItem!=null) return "无需开展";
            else return "/";
        return harmEvalOrgName1;
    }

    public String getConEvalOrgName1() {
        if (StringUtil.isEmpty(conEvalOrgName1))
            if (missingItem!=null) return "无需开展";
            else return "/";
        return conEvalOrgName1;
    }

    public Boolean getIsSysBack(){
        if (StringUtils.isEmpty(remark)) return false;
        List<String> backReasonList = Arrays.asList(
                "进行中的三同时项目将于2024年3月1日重新识别并推送风险。",
                "进行中的三同时项目将于2025年3月1日重新识别并推送风险。");
        return backReasonList.contains(remark);
    }
}
