package cn.smarthse.modules.health.entity.work.thirdtime;

import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Table(name = "ts_project_otherfile")
public @Data class TsProjectOtherfile implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 建设项_ID
     */
    @Column(name = "ts_id")
    private Long tsId;

    /**
     * 1立项， 2可研， 3设计， 4施工， 5试运行， 6项目完成
     */
    private Byte phrase;

    /**
     * 附件类别标识，见PDM或枚举  (其他附件为0)
     */
    private Byte category;
    /**
     * 扩展字段：单位id
     */
    @Column(name = "org_id")
    private Long orgId;
    /**
     * 附件名称(项目改建、扩建等资料 不为空)   
     */
    @Column(name = "attachment_name")
    private String attachmentName;

    /**
     * 附件文件file.id
     */
    @Column(name = "attachment_fid")
    private String attachmentFid;
    @Transient
    private List<SysFileModel> attachmentSfList;
    /**
     * 纸质版存放位置
     */
    @Column(name = "paper_location")
    private String paperLocation;
    
    @Transient
    private Long sort;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    private static final long serialVersionUID = 1L;

}