package cn.smarthse.modules.health.entity.work.thirdtime;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.*;

@Table(name = "ts_project_design")
public class TsProjectDesign implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 三同时项目id
     */
    @Column(name = "ts_id")
    private Long tsId;

    /**
     * 自行编制
     */
    @Column(name = "self_edit")
    private Boolean selfEdit;

    /**
     * 职业病防护设施设计专篇编制单位(tp_company.id)
     */
    @Column(name = "occ_shield_design_cid")
    private Long occShieldDesignCid;

    /**
     * 职业病防护设施设计专篇编制单位 名称（简化版使用）
     */
    @Column(name = "occ_shield_design_cname")
    private String occShieldDesignCname;

    /**
     * 设计专篇审查时间
     */
    @Column(name = "design_review_time")
    private Date designReviewTime;

    /**
     * 职业卫生投资概算(整数)
     */
    @Column(name = "occ_invest")
    private BigDecimal occInvest;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取三同时项目id
     *
     * @return ts_id - 三同时项目id
     */
    public Long getTsId() {
        return tsId;
    }

    /**
     * 设置三同时项目id
     *
     * @param tsId 三同时项目id
     */
    public void setTsId(Long tsId) {
        this.tsId = tsId;
    }

    /**
     * 获取自行编制
     *
     * @return self_edit - 自行编制
     */
    public Boolean getSelfEdit() {
        return selfEdit;
    }

    /**
     * 设置自行编制
     *
     * @param selfEdit 自行编制
     */
    public void setSelfEdit(Boolean selfEdit) {
        this.selfEdit = selfEdit;
    }

    /**
     * 获取职业病防护设施设计专篇编制单位(tp_company.id)
     *
     * @return occ_shield_design_cid - 职业病防护设施设计专篇编制单位(tp_company.id)
     */
    public Long getOccShieldDesignCid() {
        return occShieldDesignCid;
    }

    /**
     * 设置职业病防护设施设计专篇编制单位(tp_company.id)
     *
     * @param occShieldDesignCid 职业病防护设施设计专篇编制单位(tp_company.id)
     */
    public void setOccShieldDesignCid(Long occShieldDesignCid) {
        this.occShieldDesignCid = occShieldDesignCid;
    }

    /**
     * 获取设计专篇审查时间
     *
     * @return design_review_time - 设计专篇审查时间
     */
    public Date getDesignReviewTime() {
        return designReviewTime;
    }

    /**
     * 设置设计专篇审查时间
     *
     * @param designReviewTime 设计专篇审查时间
     */
    public void setDesignReviewTime(Date designReviewTime) {
        this.designReviewTime = designReviewTime;
    }

    /**
     * 获取职业卫生投资概算(整数)
     *
     * @return occ_invest - 职业卫生投资概算(整数)
     */
    public BigDecimal getOccInvest() {
        return occInvest;
    }

    /**
     * 设置职业卫生投资概算(整数)
     *
     * @param occInvest 职业卫生投资概算(整数)
     */
    public void setOccInvest(BigDecimal occInvest) {
        this.occInvest = occInvest;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    public String getOccShieldDesignCname() {
        return occShieldDesignCname;
    }

    public void setOccShieldDesignCname(String occShieldDesignCname) {
        this.occShieldDesignCname = occShieldDesignCname;
    }
}