package cn.smarthse.modules.health.entity.work.thirdtime;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.*;

@Table(name = "ts_project_debug")
public class TsProjectDebug implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 三同时项目id
     */
    @Column(name = "ts_id")
    private Long tsId;

    /**
     * 试运行开始时间
     */
    @Column(name = "debug_start_time")
    private Date debugStartTime;

    /**
     * 验收通过时间
     */
    @Column(name = "check_pass_time")
    private Date checkPassTime;

    /**
     * 方案审查时间
     */
    @Column(name = "way_check_time")
    private Date wayCheckTime;

    /**
     * 自行编制
     */
    @Column(name = "self_edit")
    private Boolean selfEdit;

    /**
     * 职业病危害控制效果评价报告编制单位（tp_company.id）
     */
    @Column(name = "occ_control_report_cid")
    private Long occControlReportCid;

    /**
     * 职业病危害控制效果评价委托书(file.id)
     */
    @Column(name = "occ_control_proxy_fid")
    private String occControlProxyFid;

    /**
     * 报告评审时间
     */
    @Column(name = "report_review_time")
    private Date reportReviewTime;

    /**
     * 职业病危害类别   1一般  2较重    3严重
     */
    @Column(name = "occ_type")
    private Byte occType;

    /**
     * 项目实际总投资
     */
    @Column(name = "pro_real_total_invest")
    private BigDecimal proRealTotalInvest;

    /**
     * 职业卫生实际投资
     */
    @Column(name = "occ_real_total_invest")
    private BigDecimal occRealTotalInvest;

    /**
     * 职业病防护设施验收时间
     */
    @Column(name = "occ_safeguard_check_time")
    private Date occSafeguardCheckTime;

    /**
     * 存在的主要职业病危害因素
     */
    @Column(name = "main_occ_hazards")
    private String mainOccHazards;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取三同时项目id
     *
     * @return ts_id - 三同时项目id
     */
    public Long getTsId() {
        return tsId;
    }

    /**
     * 设置三同时项目id
     *
     * @param tsId 三同时项目id
     */
    public void setTsId(Long tsId) {
        this.tsId = tsId;
    }

    /**
     * 获取试运行开始时间
     *
     * @return debug_start_time - 试运行开始时间
     */
    public Date getDebugStartTime() {
        return debugStartTime;
    }

    /**
     * 设置试运行开始时间
     *
     * @param debugStartTime 试运行开始时间
     */
    public void setDebugStartTime(Date debugStartTime) {
        this.debugStartTime = debugStartTime;
    }

    /**
     * 获取验收通过时间
     *
     * @return check_pass_time - 验收通过时间
     */
    public Date getCheckPassTime() {
        return checkPassTime;
    }

    /**
     * 设置验收通过时间
     *
     * @param checkPassTime 验收通过时间
     */
    public void setCheckPassTime(Date checkPassTime) {
        this.checkPassTime = checkPassTime;
    }

    /**
     * 获取方案审查时间
     *
     * @return way_check_time - 方案审查时间
     */
    public Date getWayCheckTime() {
        return wayCheckTime;
    }

    /**
     * 设置方案审查时间
     *
     * @param wayCheckTime 方案审查时间
     */
    public void setWayCheckTime(Date wayCheckTime) {
        this.wayCheckTime = wayCheckTime;
    }

    /**
     * 获取自行编制
     *
     * @return self_edit - 自行编制
     */
    public Boolean getSelfEdit() {
        return selfEdit;
    }

    /**
     * 设置自行编制
     *
     * @param selfEdit 自行编制
     */
    public void setSelfEdit(Boolean selfEdit) {
        this.selfEdit = selfEdit;
    }

    /**
     * 获取职业病危害控制效果评价报告编制单位（tp_company.id）
     *
     * @return occ_control_report_cid - 职业病危害控制效果评价报告编制单位（tp_company.id）
     */
    public Long getOccControlReportCid() {
        return occControlReportCid;
    }

    /**
     * 设置职业病危害控制效果评价报告编制单位（tp_company.id）
     *
     * @param occControlReportCid 职业病危害控制效果评价报告编制单位（tp_company.id）
     */
    public void setOccControlReportCid(Long occControlReportCid) {
        this.occControlReportCid = occControlReportCid;
    }

    /**
     * 获取职业病危害控制效果评价委托书(file.id)
     *
     * @return occ_control_proxy_fid - 职业病危害控制效果评价委托书(file.id)
     */
    public String getOccControlProxyFid() {
        return occControlProxyFid;
    }

    /**
     * 设置职业病危害控制效果评价委托书(file.id)
     *
     * @param occControlProxyFid 职业病危害控制效果评价委托书(file.id)
     */
    public void setOccControlProxyFid(String occControlProxyFid) {
        this.occControlProxyFid = occControlProxyFid == null ? null : occControlProxyFid.trim();
    }

    /**
     * 获取报告评审时间
     *
     * @return report_review_time - 报告评审时间
     */
    public Date getReportReviewTime() {
        return reportReviewTime;
    }

    /**
     * 设置报告评审时间
     *
     * @param reportReviewTime 报告评审时间
     */
    public void setReportReviewTime(Date reportReviewTime) {
        this.reportReviewTime = reportReviewTime;
    }

    /**
     * 获取职业病危害类别   1一般  2较重    3严重
     *
     * @return occ_type - 职业病危害类别   1一般  2较重    3严重
     */
    public Byte getOccType() {
        return occType;
    }

    /**
     * 设置职业病危害类别   1一般  2较重    3严重
     *
     * @param occType 职业病危害类别   1一般  2较重    3严重
     */
    public void setOccType(Byte occType) {
        this.occType = occType;
    }

    /**
     * 获取项目实际总投资
     *
     * @return pro_real_total_invest - 项目实际总投资
     */
    public BigDecimal getProRealTotalInvest() {
        return proRealTotalInvest;
    }

    /**
     * 设置项目实际总投资
     *
     * @param proRealTotalInvest 项目实际总投资
     */
    public void setProRealTotalInvest(BigDecimal proRealTotalInvest) {
        this.proRealTotalInvest = proRealTotalInvest;
    }

    /**
     * 获取职业卫生实际投资
     *
     * @return occ_real_total_invest - 职业卫生实际投资
     */
    public BigDecimal getOccRealTotalInvest() {
        return occRealTotalInvest;
    }

    /**
     * 设置职业卫生实际投资
     *
     * @param occRealTotalInvest 职业卫生实际投资
     */
    public void setOccRealTotalInvest(BigDecimal occRealTotalInvest) {
        this.occRealTotalInvest = occRealTotalInvest;
    }

    /**
     * 获取职业病防护设施验收时间
     *
     * @return occ_safeguard_check_time - 职业病防护设施验收时间
     */
    public Date getOccSafeguardCheckTime() {
        return occSafeguardCheckTime;
    }

    /**
     * 设置职业病防护设施验收时间
     *
     * @param occSafeguardCheckTime 职业病防护设施验收时间
     */
    public void setOccSafeguardCheckTime(Date occSafeguardCheckTime) {
        this.occSafeguardCheckTime = occSafeguardCheckTime;
    }

    /**
     * 获取存在的主要职业病危害因素
     *
     * @return main_occ_hazards - 存在的主要职业病危害因素
     */
    public String getMainOccHazards() {
        return mainOccHazards;
    }

    /**
     * 设置存在的主要职业病危害因素
     *
     * @param mainOccHazards 存在的主要职业病危害因素
     */
    public void setMainOccHazards(String mainOccHazards) {
        this.mainOccHazards = mainOccHazards == null ? null : mainOccHazards.trim();
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }
}