package cn.smarthse.modules.health.entity.work.thirdtime;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

import lombok.Data;

@Table(name = "ts_project_construction")
public @Data class TsProjectConstruction implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 三同时项目id
     */
    @Column(name = "ts_id")
    private Long tsId;

    /**
     * 建设工期 开始时间
     */
    @Column(name = "build_begin_time")
    private Date buildBeginTime;

    /**
     * 建设工期 结束时间
     */
    @Column(name = "build_end_time")
    private Date buildEndTime;

    /**
     * 施工单位id
     */
    @Deprecated
    @Column(name = "build_org_cid")
    private Long buildOrgCid;

    /**
     * 施工单位名称
     */
    @Deprecated
    @Column(name = "build_org_name")
    private String buildOrgName;

    /**
     * 施工单位资质证书
     */
    @Deprecated
    @Column(name = "build_org_certi_fid")
    private String buildOrgCertiFid;

    /**
     * 施工单位资质证书 编号
     */
    @Column(name = "build_org_certi_fno")
    private String buildOrgCertiFno;

    /**
     * 监理单位id
     */
    @Column(name = "supervision_org_cid")
    private Long supervisionOrgCid;

    /**
     * 监理单位名称
     */
    @Column(name = "supervision_org_name")
    private String supervisionOrgName;

    /**
     * 监理单位资质证书
     */
    @Column(name = "supervision_org_certi_fid")
    private String supervisionOrgCertiFid;

    /**
     * 监理单位资质证书 编号
     */
    @Column(name = "supervision_org_certi_fno")
    private String supervisionOrgCertiFno;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    private static final long serialVersionUID = 1L;

}