package cn.smarthse.modules.health.entity.work.thirdtime;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

@Table(name = "ts_project_basicinfo_link")
public class TsProjectBasicinfoLink implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 三同时项目id
     */
    @Column(name = "ts_id")
    private Long tsId;

    /**
     * 1.项目人员信息  2.项目设备设施信息   3.项目物料信息   4.项目工艺信息   5.项目建（构）筑物信息   6.项目管理制度信息
     */
    private Byte category;

    /**
     * 所对应数据项的ID(如 类型为1  就为人员信息的ID)
     */
    @Column(name = "link_id")
    private Long linkId;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取三同时项目id
     *
     * @return ts_id - 三同时项目id
     */
    public Long getTsId() {
        return tsId;
    }

    /**
     * 设置三同时项目id
     *
     * @param tsId 三同时项目id
     */
    public void setTsId(Long tsId) {
        this.tsId = tsId;
    }

    /**
     * 获取1.项目人员信息  2.项目设备设施信息   3.项目物料信息   4.项目工艺信息   5.项目建（构）筑物信息   6.项目管理制度信息
     *
     * @return category - 1.项目人员信息  2.项目设备设施信息   3.项目物料信息   4.项目工艺信息   5.项目建（构）筑物信息   6.项目管理制度信息
     */
    public Byte getCategory() {
        return category;
    }

    /**
     * 设置1.项目人员信息  2.项目设备设施信息   3.项目物料信息   4.项目工艺信息   5.项目建（构）筑物信息   6.项目管理制度信息
     *
     * @param category 1.项目人员信息  2.项目设备设施信息   3.项目物料信息   4.项目工艺信息   5.项目建（构）筑物信息   6.项目管理制度信息
     */
    public void setCategory(Byte category) {
        this.category = category;
    }

    /**
     * 获取所对应数据项的ID(如 类型为1  就为人员信息的ID)
     *
     * @return link_id - 所对应数据项的ID(如 类型为1  就为人员信息的ID)
     */
    public Long getLinkId() {
        return linkId;
    }

    /**
     * 设置所对应数据项的ID(如 类型为1  就为人员信息的ID)
     *
     * @param linkId 所对应数据项的ID(如 类型为1  就为人员信息的ID)
     */
    public void setLinkId(Long linkId) {
        this.linkId = linkId;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }
}