package cn.smarthse.modules.health.entity.work.thirdtime;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

@Table(name = "ts_project")
public class TsProject implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 项目编号
     */
    @Column(name = "project_no")
    private String projectNo;

    /**
     * 项目名称
     */
    @Column(name = "project_name")
    private String projectName;

    /**
     * 项目性质((1新建  2扩建  3改建   4技术引进   5技术改造)
     */
    @Column(name = "project_type")
    private Byte projectType;

    /**
     * 项目负责人
     */
    @Column(name = "leader_sid")
    private Long leaderSid;
    @Column(name = "leader_name")
    private String leaderName;

    /**
     * 开始时间
     */
    @Column(name = "begin_time")
    private Date beginTime;

    /**
     * 1立项， 2可研， 3设计， 4施工， 5试运行， 6项目完成
     */
    private Byte phrase;

    /**
     * 标识六个阶段的配置（1表示已完成）
     */
    @Column(name = "finish_config")
    private String finishConfig;

    /**
     * 信息录入阶段：
            1 立项阶段， 
            2 可研职业卫生阶段，
            3 设计职业卫生阶段 
            4  施工阶段  
            5 试运行基础阶段 
            6 试运行职业卫生阶段 
            7 项目完成
     */
    @Column(name = "input_phrase")
    private Byte inputPhrase;

    /**
     * 1 终止， 0项目正常（默认）
     */
    @Column(name = "is_close")
    private Boolean isClose;

    /**
     * 终止原因
     */
    @Column(name = "close_reason")
    private String closeReason;

    /**
     * 完成时间
     */
    @Column(name = "finish_time")
    private Date finishTime;

    /**
     * 项目真实的完成时间
     */
    @Column(name = "pro_finish_time")
    private Date proFinishTime;

    /**
     * 是否完成
     */
    @Column(name = "is_finish")
    private Boolean isFinish;

    /**
     * 是否作废
     */
    @Column(name = "is_void")
    private Boolean isVoid;
    /**
     * 备注
     */
    private String remark;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人对应的部门
     */
    @Column(name = "org_id")
    private String orgId;
    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取项目编号
     *
     * @return project_no - 项目编号
     */
    public String getProjectNo() {
        return projectNo;
    }

    /**
     * 设置项目编号
     *
     * @param projectNo 项目编号
     */
    public void setProjectNo(String projectNo) {
        this.projectNo = projectNo == null ? null : projectNo.trim();
    }

    /**
     * 获取项目名称
     *
     * @return project_name - 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 设置项目名称
     *
     * @param projectName 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName == null ? null : projectName.trim();
    }

    /**
     * 获取项目性质((1新建  2扩建  3改建   4技术引进   5技术改造)
     *
     * @return project_type - 项目性质((1新建  2扩建  3改建   4技术引进   5技术改造)
     */
    public Byte getProjectType() {
        return projectType;
    }

    /**
     * 设置项目性质((1新建  2扩建  3改建   4技术引进   5技术改造)
     *
     * @param projectType 项目性质((1新建  2扩建  3改建   4技术引进   5技术改造)
     */
    public void setProjectType(Byte projectType) {
        this.projectType = projectType;
    }

    /**
     * 获取项目负责人
     *
     * @return leader_sid - 项目负责人
     */
    public Long getLeaderSid() {
        return leaderSid;
    }

    /**
     * 设置项目负责人
     *
     * @param leaderSid 项目负责人
     */
    public void setLeaderSid(Long leaderSid) {
        this.leaderSid = leaderSid;
    }

    /**
     * 获取开始时间
     *
     * @return begin_time - 开始时间
     */
    public Date getBeginTime() {
        return beginTime;
    }

    /**
     * 设置开始时间
     *
     * @param beginTime 开始时间
     */
    public void setBeginTime(Date beginTime) {
        this.beginTime = beginTime;
    }

    /**
     * 获取1立项， 2可研， 3设计， 4施工， 5试运行， 6项目完成
     *
     * @return phrase - 1立项， 2可研， 3设计， 4施工， 5试运行， 6项目完成
     */
    public Byte getPhrase() {
        return phrase;
    }

    /**
     * 设置1立项， 2可研， 3设计， 4施工， 5试运行， 6项目完成
     *
     * @param phrase 1立项， 2可研， 3设计， 4施工， 5试运行， 6项目完成
     */
    public void setPhrase(Byte phrase) {
        this.phrase = phrase;
    }

    /**
     * 获取标识六个阶段的配置（1表示已完成）
     *
     * @return finish_config - 标识六个阶段的配置（1表示已完成）
     */
    public String getFinishConfig() {
        return finishConfig;
    }

    /**
     * 设置标识六个阶段的配置（1表示已完成）
     *
     * @param finishConfig 标识六个阶段的配置（1表示已完成）
     */
    public void setFinishConfig(String finishConfig) {
        this.finishConfig = finishConfig == null ? null : finishConfig.trim();
    }

    /**
     * 获取信息录入阶段：
            1 立项阶段， 
            2 可研职业卫生阶段，
            3 设计职业卫生阶段 
            4  施工阶段  
            5 试运行基础阶段 
            6 试运行职业卫生阶段 
            7 项目完成
     *
     * @return input_phrase - 信息录入阶段：
            1 立项阶段， 
            2 可研职业卫生阶段，
            3 设计职业卫生阶段 
            4  施工阶段  
            5 试运行基础阶段 
            6 试运行职业卫生阶段 
            7 项目完成
     */
    public Byte getInputPhrase() {
        return inputPhrase;
    }

    /**
     * 设置信息录入阶段：
            1 立项阶段， 
            2 可研职业卫生阶段，
            3 设计职业卫生阶段 
            4  施工阶段  
            5 试运行基础阶段 
            6 试运行职业卫生阶段 
            7 项目完成
     *
     * @param inputPhrase 信息录入阶段：
            1 立项阶段， 
            2 可研职业卫生阶段，
            3 设计职业卫生阶段 
            4  施工阶段  
            5 试运行基础阶段 
            6 试运行职业卫生阶段 
            7 项目完成
     */
    public void setInputPhrase(Byte inputPhrase) {
        this.inputPhrase = inputPhrase;
    }

    /**
     * 获取1 终止， 0项目正常（默认）
     *
     * @return is_close - 1 终止， 0项目正常（默认）
     */
    public Boolean getIsClose() {
        return isClose;
    }

    /**
     * 设置1 终止， 0项目正常（默认）
     *
     * @param isClose 1 终止， 0项目正常（默认）
     */
    public void setIsClose(Boolean isClose) {
        this.isClose = isClose;
    }

    /**
     * 获取终止原因
     *
     * @return close_reason - 终止原因
     */
    public String getCloseReason() {
        return closeReason;
    }

    /**
     * 设置终止原因
     *
     * @param closeReason 终止原因
     */
    public void setCloseReason(String closeReason) {
        this.closeReason = closeReason == null ? null : closeReason.trim();
    }

    /**
     * 获取完成时间
     *
     * @return finish_time - 完成时间
     */
    public Date getFinishTime() {
        return finishTime;
    }

    /**
     * 设置完成时间
     *
     * @param finishTime 完成时间
     */
    public void setFinishTime(Date finishTime) {
        this.finishTime = finishTime;
    }

    /**
     * 获取是否完成
     *
     * @return is_finish - 是否完成
     */
    public Boolean getIsFinish() {
        return isFinish;
    }

    /**
     * 设置是否完成
     *
     * @param isFinish 是否完成
     */
    public void setIsFinish(Boolean isFinish) {
        this.isFinish = isFinish;
    }

    /**
     * 获取备注
     *
     * @return remark - 备注
     */
    public String getRemark() {
        return remark;
    }

    /**
     * 设置备注
     *
     * @param remark 备注
     */
    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

	public Boolean getIsVoid() {
		return isVoid;
	}

	public void setIsVoid(Boolean isVoid) {
		this.isVoid = isVoid;
	}

    public String getOrgId() {
        return orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public String getLeaderName() {
        return leaderName;
    }

    public void setLeaderName(String leaderName) {
        this.leaderName = leaderName;
    }

    public Date getProFinishTime() {
        return proFinishTime;
    }

    public void setProFinishTime(Date proFinishTime) {
        this.proFinishTime = proFinishTime;
    }
}