package cn.smarthse.modules.health.entity.work.statistics;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * 历年丙类企业数统计实体
 * @author 吴嘉诚
 * @date 2022/11/11 9:25
 * @desc
 */
@Data
@Table(name = "company_classc_count")
public class CompanyClassCCount implements Serializable {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    private Long cid;   //企业ID

    @Column(name = "data_year")
    private Integer dataYear;   //数据记录年份

    private Byte grade;     //职业卫生分类 1甲类 2 乙类   3丙类

    private Date gradeTime;     //评级时间

    private Byte byIndu;    //是否通过行业计算的分级分类

    private Byte isGovern;      //是否治理企业

    private Integer gradeSource;

    private Integer isShowVictims;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 0 未评估  1 已审核
     */
    @Column(name = "check_state")
    private Byte checkState;

    /**
     * 历次评级结果
     */
    @Column(name = "history_grade")
    private String historyGrade;

    /**
     * 历次评级时间
     */
    @Column(name = "history_grade_time")
    private String historyGradeTime;

}
