package cn.smarthse.modules.health.entity.work.statisticalQuery;

import java.io.Serializable;
import java.util.List;

import lombok.Data;

/**
 * 《统计模块的统计选项》
 *
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <查询统计>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 

 * @author xiaoyi（肖奕)
 * @since 2017-07-13
 */
public @Data class StatisticsOption implements Serializable {
   
	/**
	 * 
	 */
	private static final long serialVersionUID = -1929766177516189959L;
	/**
	 * 
	 */
	
	private Byte countType;  			//统计类型:1职业健康监护，2职业病危害因素检测
	private Byte healthContent; 		//职业健康监护统计内容：1体检结果汇总，2异常结果汇总，3历年体检趋势
	private Byte factorsContent;		//职业病危害因素检测统计内容：1超标情况汇总，2历年检查结果趋势
	private Byte sceneContent;		//隐患排查与治理统计内容统计内容：1隐患排查统计，2隐患治理统计 3历年隐患趋势
	private Byte timeType;				//统计时间类型：1年度，2周期
	private Byte timeRange;				//趋势统计年份：1.近3年，2.近5年
	private Integer countYear;			//统计年度
	private Integer beginYear;			//统计开始年度
	private Integer endYear;			//统计结束年度
	private Byte countObject;			//统计对象：1.岗位，2.部门
	private String workRoles;			//统计岗位id多个用逗号分隔
	private String depts;				//统计部门id多个用逗号分隔
	private List<DeptOrWork> deptOrWOrks;//统计选择的岗位或部门列表
	private String inspectionType;      //隐患类型
    
}