package cn.smarthse.modules.health.entity.work.shield.vo;

import java.io.Serializable;

import lombok.Data;

/**
 * 岗位对应的防护用品种类（包括：1、配备标准中已存在的岗位，2、岗位对应的危害因素所推荐的防护用品种类）
 * */
public @Data class ShieldWorkRelation implements Serializable{

	private static final long serialVersionUID = 1557466241225957979L;
	
	private String detailId;
	
	/**
	 * 防护用品id
	 * */
	private String shieldId;
	
	/**
	 * 防护用品种类名称
	 * */
	private String shieldName;
	
	/**
	 * 
	 * 防护用品配备标准中防护用品对应的说明
	 * */
	private String shieldDesc;
	
	/**
	 * 危害因素id
	 * */
	private Long harmId;
	
	/**
	 * 岗位工种对应的危害因素名称
	 * */
	private String nameCH;
	
	private String detailName;
	
	private String func;
	
	private String level;
	
	/**
	 * 防护用品种类说明
	 * */
	@Deprecated
	private String desc;
	
	private Integer amount;
	private String countUnit;
	private Integer cycle;
	private String cycleUnit;
	private Boolean isOnDemand;
}
