package cn.smarthse.modules.health.entity.work.shield.vo;

import java.io.Serializable;

import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.enums.shield.ShieldCountUnitEnum;
import cn.smarthse.modules.health.enums.shield.ShieldCycleUnitEnum;
import lombok.Data;

public @Data class ShieldEquipRuleInfo implements Serializable {
 
	private static final long serialVersionUID = 4006216274780543148L;
    
    private Long ruleId;
    
    private Long workId;
    
    private String workName;
    
    private String shieldTypeName;
   
    private String detailName;
    
    private String func;
    
    private Integer amount;
    
    private String countUnit;
   
    private Integer cycle;
  
    private String cycleUnit;
    
    private String cycleRule;

    private Boolean isOnDemand;
    
    private String proLevel;   

    public String getCycleRule() {
    	this.cycleRule = StringUtils.getCycleRule(this.isOnDemand, this.amount, ShieldCountUnitEnum.getName(this.countUnit), this.cycle, ShieldCycleUnitEnum.getName(this.cycleUnit));
		
		return cycleRule;
	}
   

}