package cn.smarthse.modules.health.entity.work.shield.vo;

import java.io.Serializable;
import java.util.List;

import cn.smarthse.modules.health.entity.work.shield.ProtectList;
import lombok.Data;

public @Data class ShieldEquipRuleHarm implements Serializable{/**
	 * 
	 */
	private static final long serialVersionUID = -4219765710791054798L;
	
	private Long shieldEquipRuleId;
	
	private List<HarmfactorWorkInfo> harms;
	
	private Double harmNum;
	
	private List<ProtectList> protects;
	
	/**
	 * 1、大于IDLH：根据GB/T 18664-2002中的要求，环境中污染物浓度超过IDLH浓度，此环境为立即威胁生命和健康（IDLH）环境。我们将为您配置最高级别的呼吸防护用品，请根据您的实际情况选择，购买时请咨询厂商！
	 * 
	 * 2、0：您的职业病危害因数浓度为零，根据国家标准可不佩戴，但是由于检测结果不能代表生产全过程，若生产过程中存在有可能导致产生职业病危害或危害超标的意外情况，建议您为员工选配防护用品。请咨询厂商购买适合的呼吸防护用品。
	 * 
	 * 3、只有其他污染物时：根据国家相关标准，为您推荐如下PPE，请根据实际情况选择，购买时请咨询厂商选择合适的呼吸防护用品：
	 * 
	 * 4、混合时：危害因数最大值0到1：您的职业病危害因素浓度根据计算所得危害因数小于1，根据国家标准不强制佩戴，但是：
							   1.通行的做法是危害因数大于0.5就要佩戴防护用品；
							   2.由于检测结果不能代表生产全过程，若生产过程中存在有可能导致超标的意外情况，建议您为员工选配防护用品。请咨询厂商购买适合的呼吸防护用品
	 * 
	 * 5、1到IDLH：您的职业病危害因素浓度根据计算所得危害因数最大值为X，根据GB/T 18664-2002中的要求，为您推荐如下PPE，请根据实际情况选择，购买时请咨询厂商选择适合的呼吸防护用品：
	 */
	private String harmTips = "根据国家相关标准，为您推荐如下PPE，请根据实际情况选择，购买时请咨询厂商选择合适的呼吸防护用品：";

}
