package cn.smarthse.modules.health.entity.work.shield;

import cn.smarthse.modules.health.enums.shield.ShieldCountUnitEnum;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

@Table(name = "shield_send_record_detail")
public class ShieldSendRecordDetail implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 发放记录id
     */
    @Column(name = "send_record_id")
    private Long sendRecordId;

    /**
     * 防护配备标准id
     */
    @Column(name = "shield_id")
    private Long shieldId;



    /**
     * 防护用品说明
     */
    @Column(name = "shield_name")
    private String shieldName;
    
    /**
     * 领取数量 （发放数量）
     */
    @Column(name = "fetch_amount")
    private Integer fetchAmount;
    /**
     * 是否领取
     */
    @Column(name = "is_fetch")
    private Boolean isFetch;

    /**
     * 实际领取数量
     */
    @Column(name = "real_fetch_num")
    private Boolean realFetchNum;

   /**
     * 实际领取时间
     */
    @Column(name = "real_fetch_time")
    private Boolean realFetchTime;




    /**
     * 型号
     */
    private String model;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;
    
    @Transient
    private String shieldTypeName;
    
    @Transient
    private String shieldDesc;
    
    @Transient
    private String detailName;
    
    @Transient
    private String func;

    private static final long serialVersionUID = 1L;
    
    @Column(name = "unit")
    private String unit;
    
    @Transient
    private String unitName;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取发放记录id
     *
     * @return send_record_id - 发放记录id
     */
    public Long getSendRecordId() {
        return sendRecordId;
    }

    /**
     * 设置发放记录id
     *
     * @param sendRecordId 发放记录id
     */
    public void setSendRecordId(Long sendRecordId) {
        this.sendRecordId = sendRecordId;
    }

    /**
     * 获取防护用品id
     *
     * @return shield_id - 防护用品id
     */
    public Long getShieldId() {
        return shieldId;
    }

    /**
     * 设置防护用品id
     *
     * @param shieldId 防护用品id
     */
    public void setShieldId(Long shieldId) {
        this.shieldId = shieldId;
    }

    /**
     * 获取防护用品说明
     *
     * @return shield_name - 防护用品说明
     */
    public String getShieldName() {
        return shieldName;
    }

    /**
     * 设置防护用品说明
     *
     * @param shieldName 防护用品说明
     */
    public void setShieldName(String shieldName) {
        this.shieldName = shieldName == null ? null : shieldName.trim();
    }

    /**
     * 获取领取数量
     *
     * @return fetch_amount - 领取数量
     */
    public Integer getFetchAmount() {
        return fetchAmount;
    }

    /**
     * 设置领取数量
     *
     * @param fetchAmount 领取数量
     */
    public void setFetchAmount(Integer fetchAmount) {
        this.fetchAmount = fetchAmount;
    }

    /**
     * 获取型号
     *
     * @return model - 型号
     */
    public String getModel() {
        return model;
    }

    /**
     * 设置型号
     *
     * @param model 型号
     */
    public void setModel(String model) {
        this.model = model == null ? null : model.trim();
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

	public String getShieldTypeName() {
		return shieldTypeName;
	}

	public void setShieldTypeName(String shieldTypeName) {
		this.shieldTypeName = shieldTypeName;
	}

	public String getShieldDesc() {
		return shieldDesc;
	}

	public void setShieldDesc(String shieldDesc) {
		this.shieldDesc = shieldDesc;
	}

	public String getDetailName() {
		return detailName;
	}

	public void setDetailName(String detailName) {
		this.detailName = detailName;
	}

	public String getFunc() {
		return func;
	}

	public void setFunc(String func) {
		this.func = func;
	}

	public String getUnit() {
		return unit;
	}

	public void setUnit(String unit) {
		this.unit = unit;
	}

	public String getUnitName() {
		this.unitName = ShieldCountUnitEnum.getName(this.unit);
		return unitName;
	}

	public void setUnitName(String unitName) {
		this.unitName = unitName;
	}

    public Boolean getRealFetchNum() {
        return realFetchNum;
    }

    public void setRealFetchNum(Boolean realFetchNum) {
        this.realFetchNum = realFetchNum;
    }

    public Boolean getRealFetchTime() {
        return realFetchTime;
    }

    public void setRealFetchTime(Boolean realFetchTime) {
        this.realFetchTime = realFetchTime;
    }

    public Boolean getIsFetch() {
        return isFetch;
    }

    public void setIsFetch(Boolean fetch) {
        isFetch = fetch;
    }
}