package cn.smarthse.modules.health.entity.work.shield;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import javax.persistence.*;

@Table(name = "shield_send_record")
public class ShieldSendRecord implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 发放id
     */
    @Column(name = "send_id")
    private Long sendId;
    
    /**
     * 需求方(1个人 2部门)
     */
    @Column(name = "require_type")
    private Byte requireType;
    
    /**
     * 需求人id
     */
    @Column(name = "requirer_id")
    private Long requirerId;
    
    @Transient
    private String requirerName;

    /**
     * 需求部门id
     */
    @Column(name = "require_dept_id")
    private Long requireDeptId;
    
    @Transient
    private String requireDeptName;

    /**
     * 领取人
     */
    private Long fetcher;
    
    @Transient
    private String fetcherName;

    /**
     * 备注（v2.9 新增）
     */
    private String remark;

    /**
     * 领取时间
     */
    @Column(name = "fetch_time")
    private Date fetchTime;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    private static final long serialVersionUID = 1L;
    
    @Transient
    private List<ShieldSendRecordDetail> details;
    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取发放id
     *
     * @return send_id - 发放id
     */
    public Long getSendId() {
        return sendId;
    }

    /**
     * 设置发放id
     *
     * @param sendId 发放id
     */
    public void setSendId(Long sendId) {
        this.sendId = sendId;
    }

    /**
     * 获取需求人id
     *
     * @return requirer_id - 需求人id
     */
    public Long getRequirerId() {
        return requirerId;
    }

    /**
     * 设置需求人id
     *
     * @param requirerId 需求人id
     */
    public void setRequirerId(Long requirerId) {
        this.requirerId = requirerId;
    }

    /**
     * 获取需求部门id
     *
     * @return require_dept_id - 需求部门id
     */
    public Long getRequireDeptId() {
        return requireDeptId;
    }

    /**
     * 设置需求部门id
     *
     * @param requireDeptId 需求部门id
     */
    public void setRequireDeptId(Long requireDeptId) {
        this.requireDeptId = requireDeptId;
    }

    /**
     * 获取领取人
     *
     * @return fetcher - 领取人
     */
    public Long getFetcher() {
        return fetcher;
    }

    /**
     * 设置领取人
     *
     * @param fetcher 领取人
     */
    public void setFetcher(Long fetcher) {
        this.fetcher = fetcher;
    }

    /**
     * 获取领取时间
     *
     * @return fetch_time - 领取时间
     */
    public Date getFetchTime() {
        return fetchTime;
    }

    /**
     * 设置领取时间
     *
     * @param fetchTime 领取时间
     */
    public void setFetchTime(Date fetchTime) {
        this.fetchTime = fetchTime;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

	public List<ShieldSendRecordDetail> getDetails() {
		return details;
	}

	public void setDetails(List<ShieldSendRecordDetail> details) {
		this.details = details;
	}

	public String getRequirerName() {
		return requirerName;
	}

	public void setRequirerName(String requirerName) {
		this.requirerName = requirerName;
	}

	public String getRequireDeptName() {
		return requireDeptName;
	}

	public void setRequireDeptName(String requireDeptName) {
		this.requireDeptName = requireDeptName;
	}

	public String getFetcherName() {
		return fetcherName;
	}

	public void setFetcherName(String fetcherName) {
		this.fetcherName = fetcherName;
	}

	public Byte getRequireType() {
		return requireType;
	}

	public void setRequireType(Byte requireType) {
		this.requireType = requireType;
	}

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}