package cn.smarthse.modules.health.entity.work.shield;

import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.enums.shield.ShieldCountUnitEnum;
import cn.smarthse.modules.health.enums.shield.ShieldCycleUnitEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

@Table(name = "shield_send_expire_log")
@Data
public class ShieldSendExpireLog implements Serializable {
    @Id
    private Long id;

    /**
     * 发放记录详情id
     */
    @Column(name = "send_record_detail_id")
    private Long sendRecordDetailId;

    /**
     * 企业id
     */
    private Long cid;

    /**
     * 发放对象
     */
    @Column(name = "require_type")
    private Byte requireType;

    /**
     * 配备标准详情id
     */
    @Column(name = "shield_id")
    private Long shieldId;

    /**
     * 防护用品名称
     */
    @Column(name = "shield_detail_name")
    private String shieldDetailName;

    /**
     * 领取人id
     */
    @Column(name = "requirer_id")
    private Long requirerId;

    /**
     * 领取人名称
     */
    @Column(name = "requirer_name")
    private String requirerName;

    /**
     * 工号
     */
    @Column(name = "work_no")
    private String workNo;

    /**
     * 上次领用时间
     */
    @Column(name = "last_send_time")
    private Date lastSendTime;

    /**
     * 防护用品发放周期数
     */
    private Integer cycle;

    /**
     * 防护用品发放周期类型
     */
    @Column(name = "cycle_unit")
    private String cycleUnit;

    /**
     * 岗位id
     */
    @Column(name = "work_id")
    private Long workId;

    /**
     * 岗位名称
     */
    @Column(name = "work_name")
    private String workName;

    /**
     * 部门id
     */
    @Column(name = "org_id")
    private Long orgId;

    /**
     * 部门/车间
     */
    @Column(name = "organization_name")
    private String organizationName;

    /**
     * 实际发放时间
     */
    @Column(name = "real_send_time")
    private Date realSendTime;

    /**
     * 数量
     */
    private Integer amount;

    /**
     * 数量单位
     */
    @Column(name = "count_unit")
    private String countUnit;

    /**
     * 防护用品种类说明
     */
    @Column(name = "shield_desc")
    private String shieldDesc;

    /**
     * 功能
     */
    private String func;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    private static final long serialVersionUID = 1L;

    @Transient
    private String shieldCycle;

    public String getShieldCycle() {
        shieldCycle = StringUtils.getCycleRule(false, this.amount, ShieldCountUnitEnum.getName(this.countUnit), this.cycle, ShieldCycleUnitEnum.getName(this.cycleUnit));
        return shieldCycle;
    }

}