package cn.smarthse.modules.health.entity.work.shield;

import javax.persistence.*;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 《》
 * 
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author yanao [ya@smarthse.cn]
 * @since 2017年6月29日-下午5:00:44
 */
@Table(name = "shield_send")
public class ShieldSend implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;
    
    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 发放编号
     */
    @Column(name = "send_no")
    private String sendNo;

    /**
     * 工作名称
     */
    @Column(name = "work_name")
    private String workName;

    /**
     * 发放人
     */
    private Long sender;
    
    /**
     * 发放人名称
     */
    @Column(name = "sender_name")
    private String senderName;

    /**
     * 发放时间
     */
    @Column(name = "send_time")
    private Date sendTime;

    /**
     * 纸质文件存放位置
     */
    @Column(name = "paper_site")
    private String paperSite;

    /**
     * 发放记录
     */
    @Column(name = "send_file_id")
    private String sendFileId;

    /**
     * 发放记录名称
     */
    @Column(name = "send_file_name")
    private String sendFileName;

    /**
     * 发放记录url
     */
    @Column(name = "send_file_url")
    private String sendFileUrl;

    /**
     * 需求方(1个人 2部门)
     */
    @Column(name = "require_type")
    private Byte requireType;

    /**
     * 发放状态(0未完成 1已完成)
     */
    private Byte status;

    /**
     * 审核状态  ApprovalStatusEnum
     */
    @Column(name = "approval_status")
    private Byte approvalStatus;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;
    
    /**
     * 关键工作提醒来源对应CoreWorkEnum
     * */
    @Column(name = "from_type")
    private Byte fromType;
    
    @Column(name = "from_id")
    private Long fromId;


    private static final long serialVersionUID = 1L;
    /**
     * 发放记录
     */
    @Transient
    private List<ShieldSendRecord> records;
    /**
     * 发放记录文件
     */
    @Transient
    private List<ShieldSendFile> files1 = new ArrayList<ShieldSendFile>();

    @Transient
    private Integer sendYear;

    /**
     * 可以看到该数据的部门id集合以逗号分隔
     */
    @Column(name = "org_id")
    private String orgId;

    public String getOrgId() {
        return orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取发放编号
     *
     * @return send_no - 发放编号
     */
    public String getSendNo() {
        return sendNo;
    }

    /**
     * 设置发放编号
     *
     * @param sendNo 发放编号
     */
    public void setSendNo(String sendNo) {
        this.sendNo = sendNo == null ? null : sendNo.trim();
    }

    /**
     * 获取工作名称
     *
     * @return work_name - 工作名称
     */
    public String getWorkName() {
        return workName;
    }

    /**
     * 设置工作名称
     *
     * @param workName 工作名称
     */
    public void setWorkName(String workName) {
        this.workName = workName == null ? null : workName.trim();
    }

    /**
     * 获取发放人
     *
     * @return sender - 发放人
     */
    public Long getSender() {
        return sender;
    }

    /**
     * 设置发放人
     *
     * @param sender 发放人
     */
    public void setSender(Long sender) {
        this.sender = sender;
    }

    /**
     * 获取发放时间
     *
     * @return send_time - 发放时间
     */
    public Date getSendTime() {
        return sendTime;
    }

    /**
     * 设置发放时间
     *
     * @param sendTime 发放时间
     */
    public void setSendTime(Date sendTime) {
        this.sendTime = sendTime;
    }

    /**
     * 获取纸质文件存放位置
     *
     * @return paper_site - 纸质文件存放位置
     */
    public String getPaperSite() {
        return paperSite;
    }

    /**
     * 设置纸质文件存放位置
     *
     * @param paperSite 纸质文件存放位置
     */
    public void setPaperSite(String paperSite) {
        this.paperSite = paperSite == null ? null : paperSite.trim();
    }

    /**
     * 获取发放记录
     *
     * @return send_file_id - 发放记录
     */
    public String getSendFileId() {
        return sendFileId;
    }

    /**
     * 设置发放记录
     *
     * @param sendFileId 发放记录
     */
    public void setSendFileId(String sendFileId) {
        this.sendFileId = sendFileId == null ? null : sendFileId.trim();
    }

    /**
     * 获取发放记录名称
     *
     * @return send_file_name - 发放记录名称
     */
    public String getSendFileName() {
        return sendFileName;
    }

    /**
     * 设置发放记录名称
     *
     * @param sendFileName 发放记录名称
     */
    public void setSendFileName(String sendFileName) {
        this.sendFileName = sendFileName == null ? null : sendFileName.trim();
    }

    /**
     * 获取发放记录url
     *
     * @return send_file_url - 发放记录url
     */
    public String getSendFileUrl() {
        return sendFileUrl;
    }

    /**
     * 设置发放记录url
     *
     * @param sendFileUrl 发放记录url
     */
    public void setSendFileUrl(String sendFileUrl) {
        this.sendFileUrl = sendFileUrl == null ? null : sendFileUrl.trim();
    }

    /**
     * 获取需求方(1个人 2部门)
     *
     * @return require_type - 需求方(1个人 2部门)
     */
    public Byte getRequireType() {
        return requireType;
    }

    /**
     * 设置需求方(1个人 2部门)
     *
     * @param requireType 需求方(1个人 2部门)
     */
    public void setRequireType(Byte requireType) {
        this.requireType = requireType;
    }

    /**
     * 获取发放状态(0未完成 1已完成)
     *
     * @return status - 发放状态(0未完成 1已完成)
     */
    public Byte getStatus() {
        return status;
    }

    /**
     * 设置发放状态(0未完成 1已完成)
     *
     * @param status 发放状态(0未完成 1已完成)
     */
    public void setStatus(Byte status) {
        this.status = status;
    }

    /**
     * 获取审核状态 ApprovalStatusEnum
     *
     * @return approvalStatus
     */
    public Byte getApprovalStatus() {
        return approvalStatus;
    }

    /**
     * 设置审核状态 ApprovalStatusEnum
     *
     * @param approvalStatus
     */
    public void setApprovalStatus(Byte approvalStatus) {
        this.approvalStatus = approvalStatus;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

	public Long getCid() {
		return cid;
	}

	public void setCid(Long cid) {
		this.cid = cid;
	}

	public List<ShieldSendRecord> getRecords() {
		return records;
	}

	public void setRecords(List<ShieldSendRecord> records) {
		this.records = records;
	}

	public List<ShieldSendFile> getFiles1() {
		return files1;
	}

	public void setFiles1(List<ShieldSendFile> files1) {
		this.files1 = files1;
	}

	public String getSenderName() {
		return senderName;
	}

	public void setSenderName(String senderName) {
		this.senderName = senderName;
	}

	public Byte getFromType() {
		return fromType;
	}

	public void setFromType(Byte fromType) {
		this.fromType = fromType;
	}

	public Long getFromId() {
		return fromId;
	}

	public void setFromId(Long fromId) {
		this.fromId = fromId;
	}

    public Integer getSendYear() {
        return sendYear;
    }

    public void setSendYear(Integer sendYear) {
        this.sendYear = sendYear;
    }
}