package cn.smarthse.modules.health.entity.work.shield;

import cn.smarthse.modules.health.enums.shield.ShieldCountUnitEnum;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

@Table(name = "shield_purchase_detail")
public class ShieldPurchaseDetail implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    @Column(name = "cid")
    private Long cid;

    /**
     * 采购id
     */
    @Column(name = "buy_id")
    private Long buyId;

    /**
     * 防护用品配备标准详情id
     */
    @Column(name = "shield_id")
    private Long shieldId;
    
    /**
     * 防护用品种类名称
     */
    @Transient
    private String shieldName;
    
    /**
     * 防护用品配备标准详情说明
     */
    @Transient
    private String shieldDesc;
    
    /**
     * 说明
     */
    @Column(name = "description")
    private String description;

    /**
     * 单位
     */
    @Column(name = "unit")
    private String unit;
    
    @Transient
    private String unitName;
    
    @Transient
    private String detailName;
    
    @Transient
    private String func;

    /**
     * 数量
     */
    @Column(name = "amount")
    private Integer amount;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取采购id
     *
     * @return buy_id - 采购id
     */
    public Long getBuyId() {
        return buyId;
    }

    /**
     * 设置采购id
     *
     * @param buyId 采购id
     */
    public void setBuyId(Long buyId) {
        this.buyId = buyId;
    }

    /**
     * 获取防护用品id
     *
     * @return shield_id - 防护用品id
     */
    public Long getShieldId() {
        return shieldId;
    }

    /**
     * 设置防护用品id
     *
     * @param shieldId 防护用品id
     */
    public void setShieldId(Long shieldId) {
        this.shieldId = shieldId;
    }

    /**
     * 获取说明
     *
     * @return description - 说明
     */
    public String getDescription() {
        return description;
    }

    /**
     * 设置说明
     *
     * @param description 说明
     */
    public void setDescription(String description) {
        this.description = description == null ? null : description.trim();
    }

    /**
     * 获取单位
     *
     * @return unit - 单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 设置单位
     *
     * @param unit 单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }

    /**
     * 获取数量
     *
     * @return amount - 数量
     */
    public Integer getAmount() {
        return amount;
    }

    /**
     * 设置数量
     *
     * @param amount 数量
     */
    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

	public String getShieldName() {
		return shieldName;
	}

	public void setShieldName(String shieldName) {
		this.shieldName = shieldName;
	}

	public String getShieldDesc() {
		return shieldDesc;
	}

	public void setShieldDesc(String shieldDesc) {
		this.shieldDesc = shieldDesc;
	}

	public String getUnitName() {
		if("-1".equals(this.unit)){
			this.unitName = "按需发放";
		}else {
			this.unitName = ShieldCountUnitEnum.getName(this.unit);
		}
		return unitName;
	}

	public void setUnitName(String unitName) {
		this.unitName = unitName;
	}

	public String getDetailName() {
		return detailName;
	}

	public void setDetailName(String detailName) {
		this.detailName = detailName;
	}

	public String getFunc() {
		return func;
	}

	public void setFunc(String func) {
		this.func = func;
	}
    
}