package cn.smarthse.modules.health.entity.work.shield;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

@Table(name = "shield_purchase")
public class ShieldPurchase implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 工作名称
     */
    @Column(name = "buy_name")
    private String buyName;

    /**
     * 采购编号
     */
    @Column(name = "buy_no")
    private String buyNo;

    /**
     * 采购日期
     */
    @Column(name = "buy_date")
    private Date buyDate;

    /**
     * 责任人
     */
    private Long manager;
    
    /**
     * 责任人名称
     */
    @Transient
    private String managerName;

    /**
     * 采购费用
     */
    @Column(name = "buy_cost")
    private BigDecimal buyCost;

    /**
     * 使用说明
     */
    @Column(name = "use_info")
    private String useInfo;

    /**
     * 状态
     */
    private Byte status;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;
    
    /**
     * 合格证明
     * */
    @Transient
    private List<ShieldPurchaseFile> files1 = new ArrayList<ShieldPurchaseFile>();
    
    /**
     * 采购凭证
     * */
    @Transient
    private List<ShieldPurchaseFile> files2 = new ArrayList<ShieldPurchaseFile>();
    
    /**
     * 使用说明
     * */
    @Transient
    private List<ShieldPurchaseFile> files3 = new ArrayList<ShieldPurchaseFile>();
    
    @Transient
    private List<ShieldPurchaseDetail> details = new ArrayList<ShieldPurchaseDetail>();
    
    private static final long serialVersionUID = 1L;

    /**
     * 可以看到该数据的部门id集合以逗号分隔
     */
    @Column(name = "org_id")
    private String orgId;

    public String getOrgId() {
        return orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取工作名称
     *
     * @return buy_name - 工作名称
     */
    public String getBuyName() {
        return buyName;
    }

    /**
     * 设置工作名称
     *
     * @param buyName 工作名称
     */
    public void setBuyName(String buyName) {
        this.buyName = buyName == null ? null : buyName.trim();
    }

    /**
     * 获取采购编号
     *
     * @return buy_no - 采购编号
     */
    public String getBuyNo() {
        return buyNo;
    }

    /**
     * 设置采购编号
     *
     * @param buyNo 采购编号
     */
    public void setBuyNo(String buyNo) {
        this.buyNo = buyNo == null ? null : buyNo.trim();
    }

    /**
     * 获取采购日期
     *
     * @return buy_date - 采购日期
     */
    public Date getBuyDate() {
        return buyDate;
    }

    /**
     * 设置采购日期
     *
     * @param buyDate 采购日期
     */
    public void setBuyDate(Date buyDate) {
        this.buyDate = buyDate;
    }

    /**
     * 获取责任人
     *
     * @return manager - 责任人
     */
    public Long getManager() {
        return manager;
    }

    /**
     * 设置责任人
     *
     * @param manager 责任人
     */
    public void setManager(Long manager) {
        this.manager = manager;
    }

    /**
     * 获取采购费用
     *
     * @return buy_cost - 采购费用
     */
    public BigDecimal getBuyCost() {
        return buyCost;
    }

    /**
     * 设置采购费用
     *
     * @param buyCost 采购费用
     */
    public void setBuyCost(BigDecimal buyCost) {
        this.buyCost = buyCost;
    }

    /**
     * 获取使用说明
     *
     * @return use_info - 使用说明
     */
    public String getUseInfo() {
        return useInfo;
    }

    /**
     * 设置使用说明
     *
     * @param useInfo 使用说明
     */
    public void setUseInfo(String useInfo) {
        this.useInfo = useInfo == null ? null : useInfo.trim();
    }

    /**
     * 获取状态
     *
     * @return status - 状态
     */
    public Byte getStatus() {
        return status;
    }

    /**
     * 设置状态
     *
     * @param status 状态
     */
    public void setStatus(Byte status) {
        this.status = status;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

	public String getManagerName() {
		return managerName;
	}

	public void setManagerName(String managerName) {
		this.managerName = managerName;
	}

	public List<ShieldPurchaseFile> getFiles1() {
		return files1;
	}

	public void setFiles1(List<ShieldPurchaseFile> files1) {
		this.files1 = files1;
	}

	public List<ShieldPurchaseFile> getFiles2() {
		return files2;
	}

	public void setFiles2(List<ShieldPurchaseFile> files2) {
		this.files2 = files2;
	}

	public List<ShieldPurchaseDetail> getDetails() {
		return details;
	}

	public void setDetails(List<ShieldPurchaseDetail> details) {
		this.details = details;
	}

	public List<ShieldPurchaseFile> getFiles3() {
		return files3;
	}

	public void setFiles3(List<ShieldPurchaseFile> files3) {
		this.files3 = files3;
	}
    
    
}