package cn.smarthse.modules.health.entity.work.shield;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

@Table(name = "shield_info_param")
public class ShieldInfoParam implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 名称(单位名称、周期单位名称等)
     */
    private String name;

    /**
     * 类型(1防护用品单位、2周期单位)
     */
    private Byte category;

    /**
     * 类别(1鞋类 2衣服类 3 口罩类等)
     */
    private Byte type;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取名称(单位名称、周期单位名称等)
     *
     * @return name - 名称(单位名称、周期单位名称等)
     */
    public String getName() {
        return name;
    }

    /**
     * 设置名称(单位名称、周期单位名称等)
     *
     * @param name 名称(单位名称、周期单位名称等)
     */
    public void setName(String name) {
        this.name = name == null ? null : name.trim();
    }

    /**
     * 获取类型(1防护用品单位、2周期单位)
     *
     * @return category - 类型(1防护用品单位、2周期单位)
     */
    public Byte getCategory() {
        return category;
    }

    /**
     * 设置类型(1防护用品单位、2周期单位)
     *
     * @param category 类型(1防护用品单位、2周期单位)
     */
    public void setCategory(Byte category) {
        this.category = category;
    }

    /**
     * 获取类别(1鞋类 2衣服类 3 口罩类等)
     *
     * @return type - 类别(1鞋类 2衣服类 3 口罩类等)
     */
    public Byte getType() {
        return type;
    }

    /**
     * 设置类别(1鞋类 2衣服类 3 口罩类等)
     *
     * @param type 类别(1鞋类 2衣服类 3 口罩类等)
     */
    public void setType(Byte type) {
        this.type = type;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }
}