package cn.smarthse.modules.health.entity.work.shield;

import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.enums.shield.ShieldCountUnitEnum;
import cn.smarthse.modules.health.enums.shield.ShieldCycleUnitEnum;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

@Table(name = "shield_equip_rule_detail")
public class ShieldEquipRuleDetail implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 标准id
     */
    @Column(name = "rule_id")
    private Long ruleId;

    /**
     * 防护用品种类说明
     */
    @Column(name = "shield_desc")
    private String shieldDesc;

    /**
     * 防护用品种类
     */
    @Column(name = "shield_id")
    private String shieldId;
    
    @Transient
    private String shieldName;

    /**
     * 自定义，即按需发放
     */
    @Column(name = "custom_cycle")
    private String customCycle;

    /**
     * 数量
     */
    private Integer amount;

    /**
     * 数量单位
     */
    @Column(name = "count_unit")
    private String countUnit;
    
    @Transient
    private String countUnitName;

    /**
     * 周期
     */
    private Integer cycle;

    /**
     * 周期单位
     */
    @Column(name = "cycle_unit")
    private String cycleUnit;
    
    @Transient
    private String cycleRule;

    /**
     * 是否按需领取
     */
    @Column(name = "is_on_demand")
    private Boolean isOnDemand;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    private static final long serialVersionUID = 1L;
    
    @Transient
    private String description;
    
    /**
     * 明细名称
     */
    @Column(name = "detail_name")
    private String detailName;
    
    /**
     * 功能
     */
    @Column(name = "func")
    private String func;
    
    /**
     * 附加描述
     */
    @Column(name = "other")
    private String other;
    
    /**
     * 添加类型（null、自主添加，1、常用防护用品查询推荐，2、危害因素和危险因素推荐）
     */
    @Column(name = "type")
    private Byte type;
    
    /**
     * 防护用品类型
     */
    @Transient
    private Integer protectType;
    
    @Transient
    private String proLevel;

    @Transient
    private Long workId;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取标准id
     *
     * @return rule_id - 标准id
     */
    public Long getRuleId() {
        return ruleId;
    }

    /**
     * 设置标准id
     *
     * @param ruleId 标准id
     */
    public void setRuleId(Long ruleId) {
        this.ruleId = ruleId;
    }

    /**
     * 获取防护用品种类说明
     *
     * @return shield_desc - 防护用品种类说明
     */
    public String getShieldDesc() {
    	//shieldDesc = (other == null ? "" : "("+other+")")+(shieldDesc == null ? "" : shieldDesc);
        return shieldDesc;
    }

    /**
     * 设置防护用品种类说明
     *
     * @param shieldDesc 防护用品种类说明
     */
    public void setShieldDesc(String shieldDesc) {
        this.shieldDesc = shieldDesc == null ? null : shieldDesc.trim();
    }

    /**
     * 获取防护用品种类
     *
     * @return shield_id - 防护用品种类
     */
    public String getShieldId() {
        return shieldId;
    }

    /**
     * 设置防护用品种类
     *
     * @param shieldId 防护用品种类
     */
    public void setShieldId(String shieldId) {
        this.shieldId = shieldId;
    }

    /**
     * 获取自定义，即按需发放
     *
     * @return custom_cycle - 自定义，即按需发放
     */
    public String getCustomCycle() {
        return customCycle;
    }

    /**
     * 设置自定义，即按需发放
     *
     * @param customCycle 自定义，即按需发放
     */
    public void setCustomCycle(String customCycle) {
        this.customCycle = customCycle == null ? null : customCycle.trim();
    }

    /**
     * 获取数量
     *
     * @return amount - 数量
     */
    public Integer getAmount() {
        return amount;
    }

    /**
     * 设置数量
     *
     * @param amount 数量
     */
    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    /**
     * 获取数量单位
     *
     * @return count_unit - 数量单位
     */
    public String getCountUnit() {
        return countUnit;
    }

    /**
     * 设置数量单位
     *
     * @param countUnit 数量单位
     */
    public void setCountUnit(String countUnit) {
        this.countUnit = countUnit == null ? null : countUnit.trim();
    }

    /**
     * 获取周期
     *
     * @return cycle - 周期
     */
    public Integer getCycle() {
        return cycle;
    }

    /**
     * 设置周期
     *
     * @param cycle 周期
     */
    public void setCycle(Integer cycle) {
        this.cycle = cycle;
    }

    /**
     * 获取周期单位
     *
     * @return cycle_unit - 周期单位
     */
    public String getCycleUnit() {
        return cycleUnit;
    }

    /**
     * 设置周期单位
     *
     * @param cycleUnit 周期单位
     */
    public void setCycleUnit(String cycleUnit) {
        this.cycleUnit = cycleUnit == null ? null : cycleUnit.trim();
    }

    /**
     * 获取是否按需领取
     *
     * @return is_on_demand - 是否按需领取
     */
    public Boolean getIsOnDemand() {
        return isOnDemand;
    }

    /**
     * 设置是否按需领取
     *
     * @param isOnDemand 是否按需领取
     */
    public void setIsOnDemand(Boolean isOnDemand) {
        this.isOnDemand = isOnDemand;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

	public String getShieldName() {
		return shieldName;
	}

	public void setShieldName(String shieldName) {
		this.shieldName = shieldName;
	}

	public String getCycleRule() {
		this.cycleRule = StringUtils.getCycleRule(this.isOnDemand, this.amount, ShieldCountUnitEnum.getName(this.countUnit), this.cycle, ShieldCycleUnitEnum.getName(this.cycleUnit));
		return cycleRule;
	}

	public void setCycleRule(String cycleRule) {
		this.cycleRule = cycleRule;
	}

	public String getCountUnitName() {

        this.countUnitName = ShieldCountUnitEnum.getName(this.countUnit);

		return countUnitName;
	}

	public void setCountUnitName(String countUnitName) {
		this.countUnitName = countUnitName;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getDetailName() {
		return detailName;
	}

	public void setDetailName(String detailName) {
		this.detailName = detailName;
	}

	public String getFunc() {
		return func;
	}

	public void setFunc(String func) {
		this.func = func;
	}

	public String getOther() {
		return other;
	}

	public void setOther(String other) {
		this.other = other;
	}

	public Integer getProtectType() {
		return protectType;
	}

	public void setProtectType(Integer protectType) {
		this.protectType = protectType;
	}

	public Byte getType() {
		return type;
	}

	public void setType(Byte type) {
		this.type = type;
	}

	public String getProLevel() {
		return proLevel;
	}

	public void setProLevel(String proLevel) {
		this.proLevel = proLevel;
	}

    public Long getWorkId() {
        return workId;
    }

    public void setWorkId(Long workId) {
        this.workId = workId;
    }
}