package cn.smarthse.modules.health.entity.work.shield;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Table(name = "shield_equip_rule")
public class ShieldEquipRule implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 岗位ID
     */
    @Column(name = "work_id")
    private Long workId;
    
    @Transient
    private String workName;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;
    
    /**
     * 关键工作提醒来源对应CoreWorkEnum
     * */
    @Column(name = "from_type")
    private Byte fromType;

    private static final long serialVersionUID = 1L;
    
    @Transient
    private List<ShieldEquipRuleDetail> details;
    
    @Transient
    private List<ShieldEquipRuleDanger> dangers;
    
    @Transient
    private String harmNames;
    
    @Transient
    private Byte detailType;
    @Transient
    private String proLevel;


    /**
     * 防护用品类型
     */
    @Transient
    private Integer protectType;

    
    /**
     * 岗位对应的危害因素
     */
    @Column(name = "harms")
    private String harms;

    @Transient
    private String isSharingSystem;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取岗位ID
     *
     * @return work_id - 岗位ID
     */
    public Long getWorkId() {
        return workId;
    }

    /**
     * 设置岗位ID
     *
     * @param workId 岗位ID
     */
    public void setWorkId(Long workId) {
        this.workId = workId;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

	public String getWorkName() {
		return workName;
	}

	public void setWorkName(String workName) {
		this.workName = workName;
	}

	public List<ShieldEquipRuleDetail> getDetails() {
		return details;
	}

	public void setDetails(List<ShieldEquipRuleDetail> details) {
		this.details = details;
	}

	public String getHarmNames() {
		return harmNames;
	}

	public void setHarmNames(String harmNames) {
		this.harmNames = harmNames;
	}

	public Byte getFromType() {
		return fromType;
	}

	public void setFromType(Byte fromType) {
		this.fromType = fromType;
	}

	public List<ShieldEquipRuleDanger> getDangers() {
		return dangers;
	}

	public void setDangers(List<ShieldEquipRuleDanger> dangers) {
		this.dangers = dangers;
	}

	public Byte getDetailType() {
		return detailType;
	}

	public void setDetailType(Byte detailType) {
		this.detailType = detailType;
	}

	public String getHarms() {
		return harms;
	}

	public void setHarms(String harms) {
		this.harms = harms;
	}

	public String getProLevel() {
		return proLevel;
	}

	public void setProLevel(String proLevel) {
		this.proLevel = proLevel;
	}

    public Integer getProtectType() {
        return protectType;
    }

    public void setProtectType(Integer protectType) {
        this.protectType = protectType;
    }

    public String getIsSharingSystem() {
        return isSharingSystem;
    }

    public void setIsSharingSystem(String isSharingSystem) {
        this.isSharingSystem = isSharingSystem;
    }
}