package cn.smarthse.modules.health.entity.work.shield;

import javax.persistence.*;
import java.io.Serializable;

@Table(name = "protect_list_class")
public class ProtectListClass implements Serializable {
    @Id
    @Column(name = "ID")
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Integer id;

    /**
     * 防护类型
     */
    @Column(name = "Pro_Class")
    private String proClass;

    @Column(name = "Class")
    private String clazz;

    private static final long serialVersionUID = 1L;

    /**
     * @return ID
     */
    public Integer getId() {
        return id;
    }

    /**
     * @param id
     */
    public void setId(Integer id) {
        this.id = id;
    }

    /**
     * 获取防护类型
     *
     * @return Pro_Class - 防护类型
     */
    public String getProClass() {
        return proClass;
    }

    /**
     * 设置防护类型
     *
     * @param proClass 防护类型
     */
    public void setProClass(String proClass) {
        this.proClass = proClass == null ? null : proClass.trim();
    }

    /**
     * @return Clazz
     */
    public String getClazz() {
        return clazz;
    }

    /**
     * @param clazz
     */
    public void setClass(String clazz) {
        this.clazz = clazz == null ? null : clazz.trim();
    }
}