package cn.smarthse.modules.health.entity.work.shield;

import cn.smarthse.modules.health.enums.shield.OxygenLackProtectEnum;
import org.apache.commons.lang3.StringUtils;

import javax.persistence.*;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

@Table(name = "protect_list")
public class ProtectList implements Serializable {
	@Id
    @Column(name = "ID")
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 9)")
    private Long id;

    @Column(name = "PPE_ID")
    private String ppeId;

    @Column(name = "cid")
    private Long cid;

    /**
     * 防护类型
     */
    @Column(name = "Pro_Class")
    private String proClass;

    /**
     * 防护用品名
     */
    @Column(name = "Pro_Name")
    private String proName;

    /**
     * 用途
     */
    @Column(name = "Function")
    private String function;

    /**
     * 防护等级
     */
    @Column(name = "Pro_Level")
    private String proLevel;

    /**
     * 注解
     */
    @Column(name = "Remake")
    private String remake;

    @Column(name = "Class_ID")
    private Integer classId;
    
    @Transient
    private Long ruleDetailId;
    
    /**
     * 缺氧说明/呼吸滤芯
     */
    @Transient
    private String olDesc;
    
    /**
     * 其他说明（如：滤芯）
     */
    @Transient
    private String other;
    
    /**
     * 配备标准其他说明（如：滤芯）
     */
    @Transient
    private String detailOther;
    
    @Transient
    private Boolean isSameOther;

    private static final long serialVersionUID = 1L;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    /**
     * @return PPE_ID
     */
    public String getPpeId() {
        return ppeId;
    }

    /**
     * @param ppeId
     */
    public void setPpeId(String ppeId) {
        this.ppeId = ppeId == null ? null : ppeId.trim();
    }

    /**
     * 获取防护类型
     *
     * @return Pro_Class - 防护类型
     */
    public String getProClass() {
        return proClass;
    }

    /**
     * 设置防护类型
     *
     * @param proClass 防护类型
     */
    public void setProClass(String proClass) {
        this.proClass = proClass == null ? null : proClass.trim();
    }

    /**
     * 获取防护用品名
     *
     * @return Pro_Name - 防护用品名
     */
    public String getProName() {
        return proName;
    }

    /**
     * 设置防护用品名
     *
     * @param proName 防护用品名
     */
    public void setProName(String proName) {
        this.proName = proName == null ? null : proName.trim();
    }

    /**
     * 获取用途
     *
     * @return Function - 用途
     */
    public String getFunction() {
        return function;
    }

    /**
     * 设置用途
     *
     * @param function 用途
     */
    public void setFunction(String function) {
        this.function = function == null ? null : function.trim();
    }

    /**
     * 获取防护等级
     *
     * @return Pro_Level - 防护等级
     */
    public String getProLevel() {
        return proLevel;
    }

    /**
     * 设置防护等级
     *
     * @param proLevel 防护等级
     */
    public void setProLevel(String proLevel) {
        this.proLevel = proLevel == null ? null : proLevel.trim();
    }

    /**
     * 获取注解
     *
     * @return Remake - 注解
     */
    public String getRemake() {
        return remake;
    }

    /**
     * 设置注解
     *
     * @param remake 注解
     */
    public void setRemake(String remake) {
        this.remake = remake == null ? null : remake.trim();
    }

    /**
     * @return Class_ID
     */
    public Integer getClassId() {
        return classId;
    }

    /**
     * @param classId
     */
    public void setClassId(Integer classId) {
        this.classId = classId;
    }

	public Long getRuleDetailId() {
		return ruleDetailId;
	}

	public void setRuleDetailId(Long ruleDetailId) {
		this.ruleDetailId = ruleDetailId;
	}

	public String getOlDesc() {
		this.olDesc = OxygenLackProtectEnum.getName(this.ppeId);
		return olDesc;
	}

	public void setOlDesc(String olDesc) {
		this.olDesc = olDesc;
	}

	public String getOther() {
		return other;
	}

	public void setOther(String other) {
		this.other = other;
	}

	public String getDetailOther() {
		return detailOther;
	}

	public void setDetailOther(String detailOther) {
		this.detailOther = detailOther;
	}

	public Boolean getIsSameOther() {
		if(StringUtils.isEmpty(this.other)&&StringUtils.isEmpty(this.detailOther)){
			this.isSameOther = true;
			return isSameOther;
		}else if(this.other!=null) {
			if(this.other.equals(this.detailOther)){
				this.isSameOther = true;
			}else if(this.other.indexOf("+")>=0){
				this.isSameOther = lx(this.other,this.detailOther);
			} 
			
			return isSameOther;
		}
		return isSameOther;
	}
	private boolean lx(String lx1,String lx2) {
		if(lx2.indexOf("+")<0) {
			return false;
		}
		String[] lxArray1 = lx1.split("\\+");
		String[] lxArray2 = lx2.split("\\+"); 
		if(lxArray1.length!=lxArray2.length) return false;
		Set<String> lxTotal = new HashSet<String>();
		for(String lx:lxArray1){
			lxTotal.add(lx);
		}
		for(String lx:lxArray2){
			lxTotal.add(lx);
		}
		if(lxArray1.length == lxTotal.size()) return true;
		return false;
	}
	public void setIsSameOther(Boolean isSameOther) {
		this.isSameOther = isSameOther;
	}

    public Long getCid() {
        return cid;
    }

    public void setCid(Long cid) {
        this.cid = cid;
    }
}