package cn.smarthse.modules.health.entity.work.shield;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.persistence.*;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 个人用品防护发放记录表-详情表
 * </p>
 *
 * @author zhangxu
 * @since 2023-05-10
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@Table(name = "protect_equip_issue_record_detail")
public class ProtectEquipIssueRecordDetail implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 个人防护用品发放记录主表id
     */
    private Long equipIssueRecordId;

    /**
     * 车间名称
     */
    private String workshop;

    /**
     * 岗位/工种
     */
    private String workName;

    /**
     * 危害因素id,多个用,分隔
     */
    private String factorIds;

    /**
     * 危害因素名称
     */
    private String factorNames;

    /**
     * 防护用品种类id,多个用,分隔
     */
    private String equipIds;

    /**
     * 防护用品种类及数量比如： 耳塞(10)、口罩(15)
     */
    private String equipNames;

    /**
     * 是否通过检测数据自动生成的 1是0否
     */
    private Boolean isCheckGenerate;

    /**
     * 检测id
     */
    private Long checkId;

    /**
     * 创建人
     */
    private Long createBy;

    /**
     * 创建时间
     */
    private Date createDate;

    /**
     * 最后修改人ID
     */
    private Long updateBy;

    /**
     * 最后修改时间
     */
    private Date updateDate;

    /**
     * 是否有效（0-无效，1-有效）
     */
    private Boolean isValid;
}