package cn.smarthse.modules.health.entity.work.shield;

import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;
import java.util.List;


/**
 * <p>
 * 个人防护用品发放记录--v3.2.2.1新版
 * </p>
 *
 * @author zhangxu
 * @since 2023-05-10
 */
@Data
@Accessors(chain = true)
@Table(name = "protect_equip_issue_record")
public class ProtectEquipIssueRecord implements Serializable {
    private static final long serialVersionUID = 1L;

    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;
    @Transient
    private List<Long> cids;
    @Transient
    private String companyName;

    /**
     * 备注
     */
    private String remark;

    /**
     * 发放人
     */
    private String issuedBy;

    /**
     * 发放时间
     */
    private Date issuedTime;
    @Transient
    private Date issuedEndTime;

    /**
     * 审核状态：1草稿，2待审核，3退回，4审核完成，5无需审核,6已终止
     */
    private Integer reportState;

    /**
     * 填报方式：1整体填报，2部分填报
     */
    private Integer reportType;

    /**
     * 凭证文件位置
     */
    private String credentialFileId;

    /**
     * 危害因素id,多个用,分隔
     */
    private String factorIds;
    private String factorNames;

    /**
     * 防护用品种类id,多个用,分隔
     */
    private String equipIds;
    private String equipNames;

    /**
     * 创建人
     */
    private Long createBy;

    /**
     * 创建时间
     */
    private Date createDate;

    /**
     * 最后修改人ID
     */
    private Long updateBy;
    @Transient
    private String updateByStr;

    /**
     * 最后修改时间
     */
    private Date updateDate;

    /**
     * 是否有效（0-无效，1-有效）
     */
    private Boolean isValid;


    /**
     * 搜索年份
     */
    @Transient
    private Integer year;
    @Transient
    private Date beginTime;
    @Transient
    private Date endTime;
    /**
     * 关键字（防护用品）
     */
    @Transient
    private String kewWords;

    /**
     * 附件
     */
    @Transient
    private SysFileModel sysFile;

    @Transient
    private List<ProtectEquipIssueRecordDetail> recordDetailList;

    // 关键因素画像id
    @Transient
    private Long keyFactoryId;
}
