package cn.smarthse.modules.health.entity.work.shield;

import java.io.Serializable;
import javax.persistence.*;

@Table(name = "l_09_work_type")
public class L09WorkType implements Serializable {
    /**
     * 序号
     */
    @Id
    @Column(name = "ID")
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Integer id;

    /**
     * 编号
     */
    @Column(name = "Work_type_code")
    private String workTypeCode;

    /**
     * 作业类别
     */
    @Column(name = "Work_type")
    private String workType;

    /**
     * 说明
     */
    @Column(name = "Description")
    private String description;

    /**
     * 可能造成的事故类型
     */
    @Column(name = "Type_possible_accident")
    private String typePossibleAccident;

    /**
     * 举例
     */
    @Column(name = "Example")
    private String example;

    private static final long serialVersionUID = 1L;

    /**
     * 获取序号
     *
     * @return ID - 序号
     */
    public Integer getId() {
        return id;
    }

    /**
     * 设置序号
     *
     * @param id 序号
     */
    public void setId(Integer id) {
        this.id = id;
    }

    /**
     * 获取编号
     *
     * @return Work_type_code - 编号
     */
    public String getWorkTypeCode() {
        return workTypeCode;
    }

    /**
     * 设置编号
     *
     * @param workTypeCode 编号
     */
    public void setWorkTypeCode(String workTypeCode) {
        this.workTypeCode = workTypeCode == null ? null : workTypeCode.trim();
    }

    /**
     * 获取作业类别
     *
     * @return Work_type - 作业类别
     */
    public String getWorkType() {
        return workType;
    }

    /**
     * 设置作业类别
     *
     * @param workType 作业类别
     */
    public void setWorkType(String workType) {
        this.workType = workType == null ? null : workType.trim();
    }

    /**
     * 获取说明
     *
     * @return Description - 说明
     */
    public String getDescription() {
        return description;
    }

    /**
     * 设置说明
     *
     * @param description 说明
     */
    public void setDescription(String description) {
        this.description = description == null ? null : description.trim();
    }

    /**
     * 获取可能造成的事故类型
     *
     * @return Type_possible_accident - 可能造成的事故类型
     */
    public String getTypePossibleAccident() {
        return typePossibleAccident;
    }

    /**
     * 设置可能造成的事故类型
     *
     * @param typePossibleAccident 可能造成的事故类型
     */
    public void setTypePossibleAccident(String typePossibleAccident) {
        this.typePossibleAccident = typePossibleAccident == null ? null : typePossibleAccident.trim();
    }

    /**
     * 获取举例
     *
     * @return Example - 举例
     */
    public String getExample() {
        return example;
    }

    /**
     * 设置举例
     *
     * @param example 举例
     */
    public void setExample(String example) {
        this.example = example == null ? null : example.trim();
    }
}