package cn.smarthse.modules.health.entity.work.shield;

import java.io.Serializable;
import javax.persistence.*;

@Table(name = "l_09_ppe_selection")
public class L09PpeSelection implements Serializable {
    /**
     * 序号
     */
    @Id
    @Column(name = "ID")
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Integer id;

    /**
     * 编号
     */
    @Column(name = "Work_type_code")
    private String workTypeCode;

    /**
     * 作业类别
     */
    @Column(name = "Work_type")
    private String workType;

    /**
     * 防护用品编号
     */
    @Column(name = "PPE_code_1")
    private String ppeCode1;

    /**
     * 可以使用的防护用品
     */
    @Column(name = "PPE_used")
    private String ppeUsed;

    /**
     * 防护用品编号
     */
    @Column(name = "PPE_code_2")
    private String ppeCode2;

    /**
     * 建议使用的防护用品
     */
    @Column(name = "PPE_recommend")
    private String ppeRecommend;

    private static final long serialVersionUID = 1L;

    /**
     * 获取序号
     *
     * @return ID - 序号
     */
    public Integer getId() {
        return id;
    }

    /**
     * 设置序号
     *
     * @param id 序号
     */
    public void setId(Integer id) {
        this.id = id;
    }

    /**
     * 获取编号
     *
     * @return Work_type_code - 编号
     */
    public String getWorkTypeCode() {
        return workTypeCode;
    }

    /**
     * 设置编号
     *
     * @param workTypeCode 编号
     */
    public void setWorkTypeCode(String workTypeCode) {
        this.workTypeCode = workTypeCode == null ? null : workTypeCode.trim();
    }

    /**
     * 获取作业类别
     *
     * @return Work_type - 作业类别
     */
    public String getWorkType() {
        return workType;
    }

    /**
     * 设置作业类别
     *
     * @param workType 作业类别
     */
    public void setWorkType(String workType) {
        this.workType = workType == null ? null : workType.trim();
    }

    /**
     * 获取防护用品编号
     *
     * @return PPE_code_1 - 防护用品编号
     */
    public String getPpeCode1() {
        return ppeCode1;
    }

    /**
     * 设置防护用品编号
     *
     * @param ppeCode1 防护用品编号
     */
    public void setPpeCode1(String ppeCode1) {
        this.ppeCode1 = ppeCode1 == null ? null : ppeCode1.trim();
    }

    /**
     * 获取可以使用的防护用品
     *
     * @return PPE_used - 可以使用的防护用品
     */
    public String getPpeUsed() {
        return ppeUsed;
    }

    /**
     * 设置可以使用的防护用品
     *
     * @param ppeUsed 可以使用的防护用品
     */
    public void setPpeUsed(String ppeUsed) {
        this.ppeUsed = ppeUsed == null ? null : ppeUsed.trim();
    }

    /**
     * 获取防护用品编号
     *
     * @return PPE_code_2 - 防护用品编号
     */
    public String getPpeCode2() {
        return ppeCode2;
    }

    /**
     * 设置防护用品编号
     *
     * @param ppeCode2 防护用品编号
     */
    public void setPpeCode2(String ppeCode2) {
        this.ppeCode2 = ppeCode2 == null ? null : ppeCode2.trim();
    }

    /**
     * 获取建议使用的防护用品
     *
     * @return PPE_recommend - 建议使用的防护用品
     */
    public String getPpeRecommend() {
        return ppeRecommend;
    }

    /**
     * 设置建议使用的防护用品
     *
     * @param ppeRecommend 建议使用的防护用品
     */
    public void setPpeRecommend(String ppeRecommend) {
        this.ppeRecommend = ppeRecommend == null ? null : ppeRecommend.trim();
    }
}