package cn.smarthse.modules.health.entity.work.shield;

import java.io.Serializable;
import javax.persistence.*;

@Table(name = "l_09_ppe_lifetime")
public class L09PpeLifetime implements Serializable {
    /**
     * 序号
     */
    @Id
    @Column(name = "ID")
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Integer id;

    /**
     * 作业类别编号
     */
    @Column(name = "Work_type_code")
    private String workTypeCode;

    /**
     * 作业类别
     */
    @Column(name = "Work_type")
    private String workType;

    /**
     * 典型工种
     */
    @Column(name = "Typical_worker")
    private String typicalWorker;

    /**
     * 个人防护装备
     */
    @Column(name = "PPE")
    private String ppe;

    /**
     * 个人防护装备编号
     */
    @Column(name = "PPE_code")
    private String ppeCode;

    /**
     * 个人防护装备类别
     */
    @Column(name = "PPE_type")
    private String ppeType;

    /**
     * 个人防护装备使用期限
     */
    @Column(name = "PPE_lifetime")
    private String ppeLifetime;

    /**
     * 备注
     */
    private String remark;

    private static final long serialVersionUID = 1L;

    /**
     * 获取序号
     *
     * @return ID - 序号
     */
    public Integer getId() {
        return id;
    }

    /**
     * 设置序号
     *
     * @param id 序号
     */
    public void setId(Integer id) {
        this.id = id;
    }

    /**
     * 获取作业类别编号
     *
     * @return Work_type_code - 作业类别编号
     */
    public String getWorkTypeCode() {
        return workTypeCode;
    }

    /**
     * 设置作业类别编号
     *
     * @param workTypeCode 作业类别编号
     */
    public void setWorkTypeCode(String workTypeCode) {
        this.workTypeCode = workTypeCode == null ? null : workTypeCode.trim();
    }

    /**
     * 获取作业类别
     *
     * @return Work_type - 作业类别
     */
    public String getWorkType() {
        return workType;
    }

    /**
     * 设置作业类别
     *
     * @param workType 作业类别
     */
    public void setWorkType(String workType) {
        this.workType = workType == null ? null : workType.trim();
    }

    /**
     * 获取典型工种
     *
     * @return Typical_worker - 典型工种
     */
    public String getTypicalWorker() {
        return typicalWorker;
    }

    /**
     * 设置典型工种
     *
     * @param typicalWorker 典型工种
     */
    public void setTypicalWorker(String typicalWorker) {
        this.typicalWorker = typicalWorker == null ? null : typicalWorker.trim();
    }

    /**
     * 获取个人防护装备
     *
     * @return PPE - 个人防护装备
     */
    public String getPpe() {
        return ppe;
    }

    /**
     * 设置个人防护装备
     *
     * @param ppe 个人防护装备
     */
    public void setPpe(String ppe) {
        this.ppe = ppe == null ? null : ppe.trim();
    }

    /**
     * 获取个人防护装备编号
     *
     * @return PPE_code - 个人防护装备编号
     */
    public String getPpeCode() {
        return ppeCode;
    }

    /**
     * 设置个人防护装备编号
     *
     * @param ppeCode 个人防护装备编号
     */
    public void setPpeCode(String ppeCode) {
        this.ppeCode = ppeCode == null ? null : ppeCode.trim();
    }

    /**
     * 获取个人防护装备类别
     *
     * @return PPE_type - 个人防护装备类别
     */
    public String getPpeType() {
        return ppeType;
    }

    /**
     * 设置个人防护装备类别
     *
     * @param ppeType 个人防护装备类别
     */
    public void setPpeType(String ppeType) {
        this.ppeType = ppeType == null ? null : ppeType.trim();
    }

    /**
     * 获取个人防护装备使用期限
     *
     * @return PPE_lifetime - 个人防护装备使用期限
     */
    public String getPpeLifetime() {
        return ppeLifetime;
    }

    /**
     * 设置个人防护装备使用期限
     *
     * @param ppeLifetime 个人防护装备使用期限
     */
    public void setPpeLifetime(String ppeLifetime) {
        this.ppeLifetime = ppeLifetime == null ? null : ppeLifetime.trim();
    }

    /**
     * 获取备注
     *
     * @return remark - 备注
     */
    public String getRemark() {
        return remark;
    }

    /**
     * 设置备注
     *
     * @param remark 备注
     */
    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }
}