package cn.smarthse.modules.health.entity.work.scene;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

@Table(name = "scene_inspection_table_item_warning_signs")
public class SceneInspectionTableItemWarningSigns implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 检查表ID
     */
    @Column(name = "table_id")
    private Long tableId;
    
    /**
     * 区域名称
     */
    @Column(name = "area_name")
    private String areaName;

    /**
     * 区域ID
     */
//    @Column(name = "area_id")
    @Transient
    @Deprecated
    private Long areaId;

    /**
     * 具体位置
     */
    @Column(name = "specific_location")
    private String specificLocation;

    /**
     * 警示标识编号(1.3里面有，2.0里面没有编号)
     */
    @Column(name = "warning_sings_sn")
    @Deprecated
    private String warningSingsSn;

    /**
     * 告知项目
     */
    @Column(name = "inform_project")
    private String informProject;

    /**
     * 警示标识种类
     */
    @Column(name = "warning_signs_type")
    private String warningSignsType;
    
    /**
     * 检查结果
     */
    @Column(name = "result")
    private Byte result;
    
    /**
     * 备注信息
     */
    @Column(name = "remark")
    private String remark;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    private static final long serialVersionUID = 1L;

    public String getAreaName() {
		return areaName;
	}

	public void setAreaName(String areaName) {
		this.areaName = areaName;
	}

	public Byte getResult() {
		return result;
	}

	public void setResult(Byte result) {
		this.result = result;
	}

	public String getRemark() {
		return remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	/**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取检查表ID
     *
     * @return table_id - 检查表ID
     */
    public Long getTableId() {
        return tableId;
    }

    /**
     * 设置检查表ID
     *
     * @param tableId 检查表ID
     */
    public void setTableId(Long tableId) {
        this.tableId = tableId;
    }

    /**
     * 获取区域ID
     *
     * @return area_id - 区域ID
     */
    public Long getAreaId() {
        return areaId;
    }

    /**
     * 设置区域ID
     *
     * @param areaId 区域ID
     */
    public void setAreaId(Long areaId) {
        this.areaId = areaId;
    }

    /**
     * 获取具体位置
     *
     * @return specific_location - 具体位置
     */
    public String getSpecificLocation() {
        return specificLocation;
    }

    /**
     * 设置具体位置
     *
     * @param specificLocation 具体位置
     */
    public void setSpecificLocation(String specificLocation) {
        this.specificLocation = specificLocation == null ? null : specificLocation.trim();
    }

    /**
     * 获取警示标识编号
     *
     * @return warning_sings_sn - 警示标识编号
     */
    public String getWarningSingsSn() {
        return warningSingsSn;
    }

    /**
     * 设置警示标识编号
     *
     * @param warningSingsSn 警示标识编号
     */
    public void setWarningSingsSn(String warningSingsSn) {
        this.warningSingsSn = warningSingsSn == null ? null : warningSingsSn.trim();
    }

    /**
     * 获取告知项目
     *
     * @return inform_project - 告知项目
     */
    public String getInformProject() {
        return informProject;
    }

    /**
     * 设置告知项目
     *
     * @param informProject 告知项目
     */
    public void setInformProject(String informProject) {
        this.informProject = informProject == null ? null : informProject.trim();
    }

    /**
     * 获取警示标识种类
     *
     * @return warning_signs_type - 警示标识种类
     */
    public String getWarningSignsType() {
        return warningSignsType;
    }

    /**
     * 设置警示标识种类
     *
     * @param warningSignsType 警示标识种类
     */
    public void setWarningSignsType(String warningSignsType) {
        this.warningSignsType = warningSignsType == null ? null : warningSignsType.trim();
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }
}