package cn.smarthse.modules.health.entity.work.scene;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;


import cn.smarthse.common.framework.Constants;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.validation.DataValida;
import cn.smarthse.modules.health.entity.work.reform.ReformItemBasic;

@Table(name = "scene_inspection_table_item_reform")
public class SceneInspectionTableItemReform implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 检查表ID
     */
    @Column(name = "table_id")
    private Long tableId;

    /**
     * 整改项（对应整改模块的整改项ID）
     */
    @Column(name = "reform_item_id")
    private Long reformItemId;
    
    /**
     * 整改项编号
     */
    @DataValida(nullAble=false,maxLength="32",minLength="1",name="隐患编号",group={Constants.MESSAGE_GROUP_ADD,Constants.MESSAGE_GROUP_INSPECTION_REFORM})
    @Column(name = "reform_item_sn")
    private String reformItemSn;
    
    /**
     * 整改位置名称
     */
    @Column(name = "reform_item_position_name")
    private String reformItemPositionName;
    
    /**
     * 整改项描述
     */
    @DataValida(nullAble=false,name="隐患描述",group={Constants.MESSAGE_GROUP_INSPECTION_REFORM})
    private String description;
    
    /**
     * 整改负责人姓名（冗余）
     */
    @Column(name = "reform_director_name")
    private String reformDirectorName;
    
    /**
     * 整改方案
     */
    @Column(name = "reform_solution")
    private String reformSolution;
    
    /**
     * 检查结果
     */
    @Column(name = "result")
    private Byte result;
    
    /**
     * 完成情况说明
     */
    @Column(name= "finished_info")
    private String finishedInfo;
    
    /**
     * 未完成情况说明
     */
    @Column(name= "unfinished_info")
    private String unfinishedInfo;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;
    
    /**
     * 是否查询，如果是查询的话，整改方案返回变量值。
     */
    @Transient
    private boolean isSearch=false;
    
    
    public boolean isSearch() {
		return isSearch;
	}

	public void setSearch(boolean isSearch) {
		this.isSearch = isSearch;
	}

	private static final long serialVersionUID = 1L;
    
	public String getFinishedInfo() {
		return finishedInfo;
	}

	public void setFinishedInfo(String finishedInfo) {
		this.finishedInfo = finishedInfo;
	}

	public String getUnfinishedInfo() {
		return unfinishedInfo;
	}

	public void setUnfinishedInfo(String unfinishedInfo) {
		this.unfinishedInfo = unfinishedInfo;
	}

	public Byte getResult() {
		return result;
	}

	public void setResult(Byte result) {
		this.result = result;
	}

	public String getReformItemSn() {
		return reformItemSn;
	}

	public void setReformItemSn(String reformItemSn) {
		this.reformItemSn = reformItemSn;
	}

	public String getReformItemPositionName() {
		return reformItemPositionName;
	}

	public void setReformItemPositionName(String reformItemPositionName) {
		this.reformItemPositionName = reformItemPositionName;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getReformDirectorName() {
		return reformDirectorName;
	}

	public void setReformDirectorName(String reformDirectorName) {
		this.reformDirectorName = reformDirectorName;
	}

	public String getReformSolution() {
		if(isSearch) {
			return reformSolution;
		}
		if(reformItem == null || reformItem.getAcceptance() == null) {
			return "无";
		}
		
		if(StringUtils.isBlank(reformItem.getAcceptance().getReformSolution())) {
			return "无";
		}
		String[] solutions = reformItem.getAcceptance().getReformSolution().split(Constants.SPLIT_CHAR);
		if(solutions == null || solutions.length==0) {
			return "无";
		}
		for(String s:solutions) {
			if(StringUtils.isLong(s)) {
				return "有";
			}
		}
		return "无";
	}

	public void setReformSolution(String reformSolution) {
		this.reformSolution = reformSolution;
	}

	/**
     * 整改项信息
     */
    @Transient
    private ReformItemBasic reformItem;

    public ReformItemBasic getReformItem() {
		return reformItem;
	}

	public void setReformItem(ReformItemBasic reformItem) {
		this.reformItem = reformItem;
	}

	/**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取检查表ID
     *
     * @return table_id - 检查表ID
     */
    public Long getTableId() {
        return tableId;
    }

    /**
     * 设置检查表ID
     *
     * @param tableId 检查表ID
     */
    public void setTableId(Long tableId) {
        this.tableId = tableId;
    }

    /**
     * 获取整改项（对应整改模块的整改项ID）
     *
     * @return reform_item_id - 整改项（对应整改模块的整改项ID）
     */
    public Long getReformItemId() {
        return reformItemId;
    }

    /**
     * 设置整改项（对应整改模块的整改项ID）
     *
     * @param reformItemId 整改项（对应整改模块的整改项ID）
     */
    public void setReformItemId(Long reformItemId) {
        this.reformItemId = reformItemId;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }
}