package cn.smarthse.modules.health.entity.work.scene;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

@Table(name = "scene_inspection_table_item_emergency_material")
public class SceneInspectionTableItemEmergencyMaterial implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 检查表ID
     */
    @Column(name = "table_id")
    private Long tableId;

    /**
     * 物资名称
     */
    @Column(name = "material_name")
    private String materialName;

    /**
     * 物资编号
     */
    @Column(name = "material_sn")
    private String materialSn;

    /**
     * 物资型号
     */
    @Column(name = "material_model")
    private String materialModel;

    /**
     * 物资地点
     */
    @Column(name = "material_place")
    private String materialPlace;

    /**
     * 物资数量
     */
    @Column(name = "material_number")
    private Integer materialNumber;

    /**
     * 应急物资ID
     */
    @Column(name = "material_id")
    private Long materialId;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取检查表ID
     *
     * @return table_id - 检查表ID
     */
    public Long getTableId() {
        return tableId;
    }

    /**
     * 设置检查表ID
     *
     * @param tableId 检查表ID
     */
    public void setTableId(Long tableId) {
        this.tableId = tableId;
    }

    /**
     * 获取物资名称
     *
     * @return material_name - 物资名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 设置物资名称
     *
     * @param materialName 物资名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName == null ? null : materialName.trim();
    }

    /**
     * 获取物资编号
     *
     * @return material_sn - 物资编号
     */
    public String getMaterialSn() {
        return materialSn;
    }

    /**
     * 设置物资编号
     *
     * @param materialSn 物资编号
     */
    public void setMaterialSn(String materialSn) {
        this.materialSn = materialSn == null ? null : materialSn.trim();
    }

    /**
     * 获取物资型号
     *
     * @return material_model - 物资型号
     */
    public String getMaterialModel() {
        return materialModel;
    }

    /**
     * 设置物资型号
     *
     * @param materialModel 物资型号
     */
    public void setMaterialModel(String materialModel) {
        this.materialModel = materialModel == null ? null : materialModel.trim();
    }

    /**
     * 获取物资地点
     *
     * @return material_place - 物资地点
     */
    public String getMaterialPlace() {
        return materialPlace;
    }

    /**
     * 设置物资地点
     *
     * @param materialPlace 物资地点
     */
    public void setMaterialPlace(String materialPlace) {
        this.materialPlace = materialPlace == null ? null : materialPlace.trim();
    }

    /**
     * 获取物资数量
     *
     * @return material_number - 物资数量
     */
    public Integer getMaterialNumber() {
        return materialNumber;
    }

    /**
     * 设置物资数量
     *
     * @param materialNumber 物资数量
     */
    public void setMaterialNumber(Integer materialNumber) {
        this.materialNumber = materialNumber;
    }

    /**
     * 获取应急物资ID
     *
     * @return material_id - 应急物资ID
     */
    public Long getMaterialId() {
        return materialId;
    }

    /**
     * 设置应急物资ID
     *
     * @param materialId 应急物资ID
     */
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }
}