package cn.smarthse.modules.health.entity.work.scene;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import cn.smarthse.common.framework.Constants;
import cn.smarthse.common.util.validation.DataValida;

@Table(name = "scene_inspection_table_item_custom_current")
public class SceneInspectionTableItemCustomCurrent implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 序号
     */
    private Integer sort;

    /**
     * 检查内容项
     */
    @DataValida(name="检查项目",nullAble=false,maxLength="1000",group={Constants.MESSAGE_GROUP_ADD,Constants.MESSAGE_GROUP_EDIT})
    @Column(name = "content_item")
    private String contentItem;

    /**
     * 依据
     */
    @DataValida(name="依据",nullAble=false,maxLength="255",group={Constants.MESSAGE_GROUP_ADD,Constants.MESSAGE_GROUP_EDIT})
    @Column(name = "according_as")
    private String accordingAs;
    
    /**
     * 检查结果
     */
    private Byte result;

    /**
     * 检查表ID
     */
    @DataValida(name="检查表",nullAble=false,max=Long.MAX_VALUE+"",group={Constants.MESSAGE_GROUP_ADD,Constants.MESSAGE_GROUP_EDIT})
    @Column(name = "table_id")
    private Long tableId;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取序号
     *
     * @return sort - 序号
     */
    public Integer getSort() {
        return sort;
    }

    /**
     * 设置序号
     *
     * @param sort 序号
     */
    public void setSort(Integer sort) {
        this.sort = sort;
    }

    /**
     * 获取检查内容项
     *
     * @return content_item - 检查内容项
     */
    public String getContentItem() {
        return contentItem;
    }

    /**
     * 设置检查内容项
     *
     * @param contentItem 检查内容项
     */
    public void setContentItem(String contentItem) {
        this.contentItem = contentItem == null ? null : contentItem.trim();
    }

    /**
     * 获取依据
     *
     * @return according_as - 依据
     */
    public String getAccordingAs() {
        return accordingAs;
    }

    /**
     * 设置依据
     *
     * @param accordingAs 依据
     */
    public void setAccordingAs(String accordingAs) {
        this.accordingAs = accordingAs == null ? null : accordingAs.trim();
    }

    /**
     * 获取检查表ID
     *
     * @return table_id - 检查表ID
     */
    public Long getTableId() {
        return tableId;
    }

    /**
     * 设置检查表ID
     *
     * @param tableId 检查表ID
     */
    public void setTableId(Long tableId) {
        this.tableId = tableId;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

	public Byte getResult() {
		return result;
	}

	public void setResult(Byte result) {
		this.result = result;
	}
    
    
}