package cn.smarthse.modules.health.entity.work.scene;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.Transient;

import cn.smarthse.common.framework.Constants;
import cn.smarthse.common.util.validation.DataValida;

@Table(name = "scene_inspection_table")
public class SceneInspectionTable implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 表单名称
     */
    @DataValida(nullAble=false,maxLength="16",name="检查表名称",group={Constants.MESSAGE_GROUP_ADD,Constants.MESSAGE_GROUP_EDIT})
    @Column(name = "table_name")
    private String tableName;

    /**
     * 职业卫生检查ID
     */
    @Deprecated
    @Column(name = "inspection_id")
    private Long inspectionId;

    /**
     * 检查表编码类型 见枚举：InspectionTableNativeCodeEnum
     */
    @DataValida(name="检查表编码类型",min="0",max="4",group={Constants.MESSAGE_GROUP_ADD,Constants.MESSAGE_GROUP_EDIT},nullAble=false )
    @Column(name = "table_native_code")
    private Byte tableNativeCode;
    
//    /**
//     * 检查表编码类型名称
//     */
//    @Column(name = "table_native_code_name")
//    private String tableNativeCodeName;

    /**
     * 检查表类型（职业卫生、安全、环保） 见枚举：InspectionTableTypeEnum
     */
    @DataValida(name="检查表类型",min="1",max="3",group={Constants.MESSAGE_GROUP_ADD,Constants.MESSAGE_GROUP_EDIT},nullAble=false )
    @Column(name = "table_type")
    private Byte tableType;

    /**
     * 检查表类型名称
     */
    @Column(name = "table_type_name")
    private String tableTypeName;
    
    /**
     * 特征（见表：scene_inspection_table_features）
     */
    @DataValida(name="特征",maxLength="500",group={Constants.MESSAGE_GROUP_ADD,Constants.MESSAGE_GROUP_EDIT},nullAble=false )
    private String feature;
    
    /**
     * 特征名称
     */
    @Column(name = "feature_name")
    private String featureName;

    /**
     * 状态见枚举：StatusEnum
     */
    private Byte status;
    
    /**
     * 状态名称
     */
    @Column(name = "status_name")
    private String statusName;

    /**
     * 版本号
     */
    private String version;
    
    /**
     * 编写人
     */
    private Long writer;
    
    /**
     * 编写人姓名
     */
    @Column(name = "writer_name")
    private String writerName;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;
    
    /**
     * 删除的检查内容的id
     */
    @Transient
    private String deleteItemCustomIds;
    
    /**
     * 检查内容列表
     */
    @Transient
    List<SceneInspectionTableItemCustom> itemCustomList = new ArrayList<SceneInspectionTableItemCustom>();
    
    /**
     * 设备设施检查项
     */
    @Transient
    List<SceneInspectionTableItemDevice> itemDeviceList = new ArrayList<SceneInspectionTableItemDevice>();
    
    /**
     * 整改项检查项
     */
    @Transient
    List<SceneInspectionTableItemReform> itemReformList = new ArrayList<SceneInspectionTableItemReform>();
    
    /**
     * 警示标识检查项
     */
    @Transient
    private List<SceneInspectionTableItemWarningSigns> itemWarningSingsList = new ArrayList<SceneInspectionTableItemWarningSigns>();

    private static final long serialVersionUID = 1L;
    
    public List<SceneInspectionTableItemWarningSigns> getItemWarningSingsList() {
		return itemWarningSingsList;
	}

	public void setItemWarningSingsList(List<SceneInspectionTableItemWarningSigns> itemWarningSingsList) {
		this.itemWarningSingsList = itemWarningSingsList;
	}

	public String getDeleteItemCustomIds() {
		return deleteItemCustomIds;
	}

	public void setDeleteItemCustomIds(String deleteItemCustomIds) {
		this.deleteItemCustomIds = deleteItemCustomIds;
	}

	public List<SceneInspectionTableItemCustom> getItemCustomList() {
		return itemCustomList;
	}

	public void setItemCustomList(List<SceneInspectionTableItemCustom> itemCustomList) {
		this.itemCustomList = itemCustomList;
	}

	public List<SceneInspectionTableItemDevice> getItemDeviceList() {
		return itemDeviceList;
	}

	public void setItemDeviceList(List<SceneInspectionTableItemDevice> itemDeviceList) {
		this.itemDeviceList = itemDeviceList;
	}

	public List<SceneInspectionTableItemReform> getItemReformList() {
		return itemReformList;
	}

	public void setItemReformList(List<SceneInspectionTableItemReform> itemReformList) {
		this.itemReformList = itemReformList;
	}

	/**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取表单名称
     *
     * @return table_name - 表单名称
     */
    public String getTableName() {
        return tableName;
    }

    /**
     * 设置表单名称
     *
     * @param tableName 表单名称
     */
    public void setTableName(String tableName) {
        this.tableName = tableName == null ? null : tableName.trim();
    }

    /**
     * 获取职业卫生检查ID
     *
     * @return inspection_id - 职业卫生检查ID
     */
    public Long getInspectionId() {
        return inspectionId;
    }

    /**
     * 设置职业卫生检查ID
     *
     * @param inspectionId 职业卫生检查ID
     */
    public void setInspectionId(Long inspectionId) {
        this.inspectionId = inspectionId;
    }

    /**
     * 获取检查表编码类型（0，自定义检查表；1、应急物质；2、设备设施；3、警示标识）
     *
     * @return table_native_code - 检查表编码类型（0，自定义检查表；1、应急物质；2、设备设施；3、警示标识）
     */
    public Byte getTableNativeCode() {
        return tableNativeCode;
    }

    /**
     * 设置检查表编码类型（0，自定义检查表；1、应急物质；2、设备设施；3、警示标识）
     *
     * @param tableNativeCode 检查表编码类型（0，自定义检查表；1、应急物质；2、设备设施；3、警示标识）
     */
    public void setTableNativeCode(Byte tableNativeCode) {
        this.tableNativeCode = tableNativeCode;
    }

    /**
     * 获取检查表类型（职业卫生、安全、环保）
     *
     * @return table_type - 检查表类型（职业卫生、安全、环保）
     */
    public Byte getTableType() {
        return tableType;
    }

    /**
     * 设置检查表类型（职业卫生、安全、环保）
     *
     * @param tableType 检查表类型（职业卫生、安全、环保）
     */
    public void setTableType(Byte tableType) {
        this.tableType = tableType;
    }

    /**
     * 获取特征（以逗号分隔：1、综合性；2、专业性；3、全厂；4、车间组；5、班组级）
     *
     * @return feature - 特征（以逗号分隔：1、综合性；2、专业性；3、全厂；4、车间组；5、班组级）
     */
    public String getFeature() {
        return feature;
    }

    /**
     * 设置特征（以逗号分隔：1、综合性；2、专业性；3、全厂；4、车间组；5、班组级）
     *
     * @param feature 特征（以逗号分隔：1、综合性；2、专业性；3、全厂；4、车间组；5、班组级）
     */
    public void setFeature(String feature) {
        this.feature = feature == null ? null : feature.trim();
    }

    /**
     * 获取状态（1、可编辑；2、审批中)
     *
     * @return status - 状态（1、可编辑；2、审批中)
     */
    public Byte getStatus() {
        return status;
    }

    /**
     * 设置状态（1、可编辑；2、审批中)
     *
     * @param status 状态（1、可编辑；2、审批中)
     */
    public void setStatus(Byte status) {
        this.status = status;
    }

    /**
     * 获取版本号
     *
     * @return version - 版本号
     */
    public String getVersion() {
        return version;
    }

    /**
     * 设置版本号
     *
     * @param version 版本号
     */
    public void setVersion(String version) {
        this.version = version == null ? null : version.trim();
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

	public String getTableTypeName() {
		return tableTypeName;
	}

	public void setTableTypeName(String tableTypeName) {
		this.tableTypeName = tableTypeName;
	}

	public String getFeatureName() {
		return featureName;
	}

	public void setFeatureName(String featureName) {
		this.featureName = featureName;
	}

	public String getStatusName() {
		return statusName;
	}

	public void setStatusName(String statusName) {
		this.statusName = statusName;
	}

	public Long getWriter() {
		return writer;
	}

	public void setWriter(Long writer) {
		this.writer = writer;
	}

	public String getWriterName() {
		return writerName;
	}

	public void setWriterName(String writerName) {
		this.writerName = writerName;
	}
}