package cn.smarthse.modules.health.entity.work.scene;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import cn.smarthse.common.framework.Constants;
import cn.smarthse.common.util.validation.DataValida;

@Deprecated
@Table(name = "scene_inspection_superiors")
public class SceneInspectionSuperiors implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 工作名称
     */
    @DataValida(name="工作名称",nullAble=false,maxLength="16",group={Constants.MESSAGE_GROUP_ADD,Constants.MESSAGE_GROUP_EDIT})
    @Column(name = "work_name")
    private String workName;

    /**
     * 检查编号
     */
    @DataValida(name="检查编号",nullAble=false,maxLength="32",group={Constants.MESSAGE_GROUP_ADD,Constants.MESSAGE_GROUP_EDIT})
    @Column(name = "inspection_no")
    private String inspectionNo;

    /**
     * 实际检查时间
     */
    @DataValida(name="检查时间",nullAble=false,group={Constants.MESSAGE_GROUP_ADD,Constants.MESSAGE_GROUP_EDIT})
    @Column(name = "inspection_actual_time")
    private Date inspectionActualTime;

    /**
     * 检查类型
     */
    @Column(name = "inspection_type_name")
    private String inspectionTypeName;

    /**
     * 检查类型，对应：职业健康、安全，以逗号分隔
     */
    @DataValida(name="检查类型",nullAble=false,group={Constants.MESSAGE_GROUP_ADD,Constants.MESSAGE_GROUP_EDIT})
    @Column(name = "inspection_type_1")
    private String inspectionType1;

    /**
     * 纸质检查表存放位置
     */
    @DataValida(name="纸质检查表存放位置",nullAble=false,group={Constants.MESSAGE_GROUP_ADD,Constants.MESSAGE_GROUP_EDIT})
    @Column(name = "inspection_table_paper_store_place")
    private String inspectionTablePaperStorePlace;

    /**
     * 监管意见资料
     */
    @Column(name = "supervisory_opinion_files")
    private String supervisoryOpinionFiles;

    /**
     * 其他附件
     */
    @Column(name = "other_files")
    private String otherFiles;

    /**
     * 状态（1、存草稿；2、完成)
     */
    private Byte status;

    /**
     * 检查结果（无隐患，有隐患）
     */
    private Byte result;

    /**
     * 上级监督检查部门
     */
    @Column(name = "super_department")
    private String superDepartment;

    /**
     * 状态（冗余）
     */
    @Column(name = "status_name")
    private String statusName;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取工作名称
     *
     * @return work_name - 工作名称
     */
    public String getWorkName() {
        return workName;
    }

    /**
     * 设置工作名称
     *
     * @param workName 工作名称
     */
    public void setWorkName(String workName) {
        this.workName = workName == null ? null : workName.trim();
    }

    /**
     * 获取检查编号
     *
     * @return inspection_no - 检查编号
     */
    public String getInspectionNo() {
        return inspectionNo;
    }

    /**
     * 设置检查编号
     *
     * @param inspectionNo 检查编号
     */
    public void setInspectionNo(String inspectionNo) {
        this.inspectionNo = inspectionNo == null ? null : inspectionNo.trim();
    }

    /**
     * 获取实际检查时间
     *
     * @return inspection_actual_time - 实际检查时间
     */
    public Date getInspectionActualTime() {
        return inspectionActualTime;
    }

    /**
     * 设置实际检查时间
     *
     * @param inspectionActualTime 实际检查时间
     */
    public void setInspectionActualTime(Date inspectionActualTime) {
        this.inspectionActualTime = inspectionActualTime;
    }

    /**
     * 获取检查类型
     *
     * @return inspection_type_name - 检查类型
     */
    public String getInspectionTypeName() {
        return inspectionTypeName;
    }

    /**
     * 设置检查类型
     *
     * @param inspectionTypeName 检查类型
     */
    public void setInspectionTypeName(String inspectionTypeName) {
        this.inspectionTypeName = inspectionTypeName == null ? null : inspectionTypeName.trim();
    }

    /**
     * 获取检查类型，对应：职业健康、安全，以逗号分隔
     *
     * @return inspection_type_1 - 检查类型，对应：职业健康、安全，以逗号分隔
     */
    public String getInspectionType1() {
        return inspectionType1;
    }

    /**
     * 设置检查类型，对应：职业健康、安全，以逗号分隔
     *
     * @param inspectionType1 检查类型，对应：职业健康、安全，以逗号分隔
     */
    public void setInspectionType1(String inspectionType1) {
        this.inspectionType1 = inspectionType1 == null ? null : inspectionType1.trim();
    }

    /**
     * 获取纸质检查表存放位置
     *
     * @return inspection_table_paper_store_place - 纸质检查表存放位置
     */
    public String getInspectionTablePaperStorePlace() {
        return inspectionTablePaperStorePlace;
    }

    /**
     * 设置纸质检查表存放位置
     *
     * @param inspectionTablePaperStorePlace 纸质检查表存放位置
     */
    public void setInspectionTablePaperStorePlace(String inspectionTablePaperStorePlace) {
        this.inspectionTablePaperStorePlace = inspectionTablePaperStorePlace == null ? null : inspectionTablePaperStorePlace.trim();
    }

    /**
     * 获取监管意见资料
     *
     * @return supervisory_opinion_files - 监管意见资料
     */
    public String getSupervisoryOpinionFiles() {
        return supervisoryOpinionFiles;
    }

    /**
     * 设置监管意见资料
     *
     * @param supervisoryOpinionFiles 监管意见资料
     */
    public void setSupervisoryOpinionFiles(String supervisoryOpinionFiles) {
        this.supervisoryOpinionFiles = supervisoryOpinionFiles == null ? null : supervisoryOpinionFiles.trim();
    }

    /**
     * 获取其他附件
     *
     * @return other_files - 其他附件
     */
    public String getOtherFiles() {
        return otherFiles;
    }

    /**
     * 设置其他附件
     *
     * @param otherFiles 其他附件
     */
    public void setOtherFiles(String otherFiles) {
        this.otherFiles = otherFiles == null ? null : otherFiles.trim();
    }

    /**
     * 获取状态（1、存草稿；2、完成)
     *
     * @return status - 状态（1、存草稿；2、完成)
     */
    public Byte getStatus() {
        return status;
    }

    /**
     * 设置状态（1、存草稿；2、完成)
     *
     * @param status 状态（1、存草稿；2、完成)
     */
    public void setStatus(Byte status) {
        this.status = status;
    }

    /**
     * 获取检查结果（无隐患，有隐患）
     *
     * @return result - 检查结果（无隐患，有隐患）
     */
    public Byte getResult() {
        return result;
    }

    /**
     * 设置检查结果（无隐患，有隐患）
     *
     * @param result 检查结果（无隐患，有隐患）
     */
    public void setResult(Byte result) {
        this.result = result;
    }

    /**
     * 获取上级监督检查部门
     *
     * @return super_department - 上级监督检查部门
     */
    public String getSuperDepartment() {
        return superDepartment;
    }

    /**
     * 设置上级监督检查部门
     *
     * @param superDepartment 上级监督检查部门
     */
    public void setSuperDepartment(String superDepartment) {
        this.superDepartment = superDepartment == null ? null : superDepartment.trim();
    }

    /**
     * 获取状态（冗余）
     *
     * @return status_name - 状态（冗余）
     */
    public String getStatusName() {
        return statusName;
    }

    /**
     * 设置状态（冗余）
     *
     * @param statusName 状态（冗余）
     */
    public void setStatusName(String statusName) {
        this.statusName = statusName == null ? null : statusName.trim();
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }
}