package cn.smarthse.modules.health.entity.work.scene;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

@Table(name = "scene_inspection_summary_item_result_reform")
public class SceneInspectionSummaryItemResultReform implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 已完成情况说明
     */
    @Column(name = "finished_explain")
    private String finishedExplain;

    /**
     * 未完成情况说明
     */
    @Column(name = "unfinished_explain")
    private String unfinishedExplain;

    /**
     * 图像附件（文件ID，以逗号隔开）
     */
    @Column(name = "image_files")
    private String imageFiles;

    /**
     * 音频附件（文件ID，以逗号隔开）
     */
    @Column(name = "audio_files")
    private String audioFiles;

    /**
     * 视频附件（文件ID，以逗号隔开）
     */
    @Column(name = "video_files")
    private String videoFiles;

    /**
     * 检查结果ID
     */
    @Column(name = "result_id")
    private Long resultId;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取已完成情况说明
     *
     * @return finished_explain - 已完成情况说明
     */
    public String getFinishedExplain() {
        return finishedExplain;
    }

    /**
     * 设置已完成情况说明
     *
     * @param finishedExplain 已完成情况说明
     */
    public void setFinishedExplain(String finishedExplain) {
        this.finishedExplain = finishedExplain == null ? null : finishedExplain.trim();
    }

    /**
     * 获取未完成情况说明
     *
     * @return unfinished_explain - 未完成情况说明
     */
    public String getUnfinishedExplain() {
        return unfinishedExplain;
    }

    /**
     * 设置未完成情况说明
     *
     * @param unfinishedExplain 未完成情况说明
     */
    public void setUnfinishedExplain(String unfinishedExplain) {
        this.unfinishedExplain = unfinishedExplain == null ? null : unfinishedExplain.trim();
    }

    /**
     * 获取图像附件（文件ID，以逗号隔开）
     *
     * @return image_files - 图像附件（文件ID，以逗号隔开）
     */
    public String getImageFiles() {
        return imageFiles;
    }

    /**
     * 设置图像附件（文件ID，以逗号隔开）
     *
     * @param imageFiles 图像附件（文件ID，以逗号隔开）
     */
    public void setImageFiles(String imageFiles) {
        this.imageFiles = imageFiles == null ? null : imageFiles.trim();
    }

    /**
     * 获取音频附件（文件ID，以逗号隔开）
     *
     * @return audio_files - 音频附件（文件ID，以逗号隔开）
     */
    public String getAudioFiles() {
        return audioFiles;
    }

    /**
     * 设置音频附件（文件ID，以逗号隔开）
     *
     * @param audioFiles 音频附件（文件ID，以逗号隔开）
     */
    public void setAudioFiles(String audioFiles) {
        this.audioFiles = audioFiles == null ? null : audioFiles.trim();
    }

    /**
     * 获取视频附件（文件ID，以逗号隔开）
     *
     * @return video_files - 视频附件（文件ID，以逗号隔开）
     */
    public String getVideoFiles() {
        return videoFiles;
    }

    /**
     * 设置视频附件（文件ID，以逗号隔开）
     *
     * @param videoFiles 视频附件（文件ID，以逗号隔开）
     */
    public void setVideoFiles(String videoFiles) {
        this.videoFiles = videoFiles == null ? null : videoFiles.trim();
    }

    /**
     * 获取检查结果ID
     *
     * @return result_id - 检查结果ID
     */
    public Long getResultId() {
        return resultId;
    }

    /**
     * 设置检查结果ID
     *
     * @param resultId 检查结果ID
     */
    public void setResultId(Long resultId) {
        this.resultId = resultId;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }
}