package cn.smarthse.modules.health.entity.work.scene;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

@Table(name = "scene_inspection_summary_item_result")
public class SceneInspectionSummaryItemResult implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 检查项ID（根据检查表的类型，指向不同的检查项表）
     */
    @Column(name = "item_id")
    private Long itemId;

    /**
     * 检查表ID
     */
    @Column(name = "table_id")
    private Long tableId;

    /**
     * 检查结果汇总表ID
     */
    @Column(name = "summary_id")
    private Long summaryId;

    /**
     * 检查结果（1、有整改项；0、无整改项）
     */
    @Column(name = "inspection_reslut")
    private Byte inspectionReslut;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取检查项ID（根据检查表的类型，指向不同的检查项表）
     *
     * @return item_id - 检查项ID（根据检查表的类型，指向不同的检查项表）
     */
    public Long getItemId() {
        return itemId;
    }

    /**
     * 设置检查项ID（根据检查表的类型，指向不同的检查项表）
     *
     * @param itemId 检查项ID（根据检查表的类型，指向不同的检查项表）
     */
    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    /**
     * 获取检查表ID
     *
     * @return table_id - 检查表ID
     */
    public Long getTableId() {
        return tableId;
    }

    /**
     * 设置检查表ID
     *
     * @param tableId 检查表ID
     */
    public void setTableId(Long tableId) {
        this.tableId = tableId;
    }

    /**
     * 获取检查结果汇总表ID
     *
     * @return summary_id - 检查结果汇总表ID
     */
    public Long getSummaryId() {
        return summaryId;
    }

    /**
     * 设置检查结果汇总表ID
     *
     * @param summaryId 检查结果汇总表ID
     */
    public void setSummaryId(Long summaryId) {
        this.summaryId = summaryId;
    }

    /**
     * 获取检查结果（1、有整改项；0、无整改项）
     *
     * @return inspection_reslut - 检查结果（1、有整改项；0、无整改项）
     */
    public Byte getInspectionReslut() {
        return inspectionReslut;
    }

    /**
     * 设置检查结果（1、有整改项；0、无整改项）
     *
     * @param inspectionReslut 检查结果（1、有整改项；0、无整改项）
     */
    public void setInspectionReslut(Byte inspectionReslut) {
        this.inspectionReslut = inspectionReslut;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }
}