package cn.smarthse.modules.health.entity.work.scene;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

@Table(name = "scene_inspection_summary")
public class SceneInspectionSummary implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 检查结果记录人（员工表ID）
     */
    @Column(name = "inspection_result_recorder")
    private Long inspectionResultRecorder;

    /**
     * 检查结果记录人姓名（冗余）
     */
    @Column(name = "inspection_result_recorder_name")
    private String inspectionResultRecorderName;

    /**
     * 记录人类型（1、负责人；2、协助人）
     */
    @Column(name = "record_staff_type")
    private Byte recordStaffType;

    /**
     * 检查ID
     */
    @Column(name = "inspection_id")
    private Long inspectionId;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取检查结果记录人（员工表ID）
     *
     * @return inspection_result_recorder - 检查结果记录人（员工表ID）
     */
    public Long getInspectionResultRecorder() {
        return inspectionResultRecorder;
    }

    /**
     * 设置检查结果记录人（员工表ID）
     *
     * @param inspectionResultRecorder 检查结果记录人（员工表ID）
     */
    public void setInspectionResultRecorder(Long inspectionResultRecorder) {
        this.inspectionResultRecorder = inspectionResultRecorder;
    }

    /**
     * 获取检查结果记录人姓名（冗余）
     *
     * @return inspection_result_recorder_name - 检查结果记录人姓名（冗余）
     */
    public String getInspectionResultRecorderName() {
        return inspectionResultRecorderName;
    }

    /**
     * 设置检查结果记录人姓名（冗余）
     *
     * @param inspectionResultRecorderName 检查结果记录人姓名（冗余）
     */
    public void setInspectionResultRecorderName(String inspectionResultRecorderName) {
        this.inspectionResultRecorderName = inspectionResultRecorderName == null ? null : inspectionResultRecorderName.trim();
    }

    /**
     * 获取记录人类型（1、负责人；2、协助人）
     *
     * @return record_staff_type - 记录人类型（1、负责人；2、协助人）
     */
    public Byte getRecordStaffType() {
        return recordStaffType;
    }

    /**
     * 设置记录人类型（1、负责人；2、协助人）
     *
     * @param recordStaffType 记录人类型（1、负责人；2、协助人）
     */
    public void setRecordStaffType(Byte recordStaffType) {
        this.recordStaffType = recordStaffType;
    }

    /**
     * 获取检查ID
     *
     * @return inspection_id - 检查ID
     */
    public Long getInspectionId() {
        return inspectionId;
    }

    /**
     * 设置检查ID
     *
     * @param inspectionId 检查ID
     */
    public void setInspectionId(Long inspectionId) {
        this.inspectionId = inspectionId;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }
}