package cn.smarthse.modules.health.entity.work.scene;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import cn.smarthse.common.framework.Constants;
import cn.smarthse.common.util.validation.DataValida;
import cn.smarthse.modules.health.entity.work.reform.ReformItemBasic;

@Table(name = "scene_inspection")
public class SceneInspection implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;
    
    /**
     * 工作名称
     */
    @DataValida(name="工作名称",nullAble=false,maxLength="16",group={Constants.MESSAGE_GROUP_ADD,Constants.MESSAGE_GROUP_EDIT,Constants.MESSAGE_GROUP_SUPERIROS})
    @Column(name = "work_name")
    private String workName;

    /**
     * 检查编号
     */
    @DataValida(name="检查编号",nullAble=false,maxLength="32",group={Constants.MESSAGE_GROUP_ADD,Constants.MESSAGE_GROUP_EDIT,Constants.MESSAGE_GROUP_SUPERIROS})
    @Column(name = "inspection_no")
    private String inspectionNo;

    /**
     * 实际检查时间
     */
    @DataValida(name="实际检查时间",nullAble=false,group={Constants.MESSAGE_GROUP_ADD,Constants.MESSAGE_GROUP_EDIT,Constants.MESSAGE_GROUP_SUPERIROS})
    @Column(name = "inspection_actual_time")
    private Date inspectionActualTime;
    
    /**
     * 检查类型，对应：职业卫生、安全，以逗号分隔。
     */
    @DataValida(name="检查类型1",nullAble=false,group={Constants.MESSAGE_GROUP_ADD,Constants.MESSAGE_GROUP_EDIT,Constants.MESSAGE_GROUP_SUPERIROS})
    @Column(name = "inspection_type_1")
    private String inspectionType1;

    /**
     * 检查类型（综合性，专业性，……）
     */
    @DataValida(name="检查类型2",nullAble=false,group={Constants.MESSAGE_GROUP_ADD,Constants.MESSAGE_GROUP_EDIT})
    @Column(name = "inspection_type")
    private Byte inspectionType;
    
    /**
     * 检查类型名称
     */
    @Column(name="inspection_type_name")
    private String inspectionTypeName;

    /**
     * 检查范围（区域ID，以逗号分隔）
     */
    @DataValida(name="检查范围",nullAble=false,group={Constants.MESSAGE_GROUP_ADD,Constants.MESSAGE_GROUP_EDIT})
    @Column(name = "inspection_ranges")
    private String inspectionRanges;
    
    /**
     * 上级监督检查部门
     */
    @DataValida(name="上级检查部门",nullAble=false,group={Constants.MESSAGE_GROUP_SUPERIROS})
    @Column(name = "super_department")
    private String superDepartment;
    
    /**
     * 检查结果（无隐患，有隐患 上级监督检查特有）
     */
    @DataValida(name="检查结果",nullAble=false,group={Constants.MESSAGE_GROUP_SUPERIROS})
    private Byte result;
    
    /**
     * 检查范围（区域名称）
     */
    @Column(name="inspection_ranges_name")
    private String inspectionRangesName;

    /**
     * 检查负责人
     */
    @DataValida(name="检查负责人",nullAble=false,group={Constants.MESSAGE_GROUP_ADD,Constants.MESSAGE_GROUP_EDIT})
    @Column(name = "inspection_director")
    private Long inspectionDirector;

    /**
     * 检查负责人姓名（冗余）
     */
    @Column(name = "inspection_director_name")
    private String inspectionDirectorName;

    /**
     * 检查协作人（员工ID，以逗号分隔）
     */
    @Column(name = "inspection_collaborator")
    private String inspectionCollaborator;

    /**
     * 检查协作人姓名（冗余）
     */
    @Column(name = "inspection_collaborator_name")
    private String inspectionCollaboratorName;

    /**
     * 纸质检查表存放位置
     */
    @DataValida(name="纸质资料存放位置",nullAble=false,group={Constants.MESSAGE_GROUP_SUPERIROS})
    @Column(name = "inspection_table_paper_store_place")
    private String inspectionTablePaperStorePlace;
    
    /**
     * 监管意见资料
     */
//    @Column(name = "supervisory_opinion_files")
    @Deprecated
    private String supervisoryOpinionFiles;
    
    @Transient
    @Deprecated
    private String supervisoryOpinionFilesName;
    /**
     * 其他附件
     */
    @Column(name = "other_files")
    private String otherFiles;

    /**
     * 状态（1、存草稿；2、完成)
     */
    private Byte status;
    
    /**
     * 状态文字信息（冗余）
     */
    @Column(name = "status_name")
    private String statusName;

    /**
     * 检查内容（检查表ID，以逗号分隔）
     */
    @DataValida(name="检查项目",nullAble=false,group={Constants.MESSAGE_GROUP_ADD,Constants.MESSAGE_GROUP_EDIT})
    @Column(name = "inspection_table")
    private String inspectionTable;
    
    /**
     * 检查内容（冗余）
     */
    @Column(name = "inspection_table_name")
    private String inspectionTableName;
    /**
     * 部门id（创建人）
     */
    @Column(name = "org_id")
    private Long orgId;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;
    
    /**
     * 检查项列表，更新的时候从前台传数据过来用到。
     */
    @Transient
    private List<SceneInspectionTableItemCustomCurrent> itemCustomList=new ArrayList<SceneInspectionTableItemCustomCurrent>();
    
    /**
     * 设备设施检查项
     */
    @Transient
    List<SceneInspectionTableItemDevice> itemDeviceList = new ArrayList<SceneInspectionTableItemDevice>();
    
    /**
     * 整改项检查项
     */
    @Transient
    List<SceneInspectionTableItemReform> itemReformList = new ArrayList<SceneInspectionTableItemReform>();
    
    /**
     * 警示标识检查项
     */
    @Transient
    private List<SceneInspectionTableItemWarningSigns> itemWarningSingsList = new ArrayList<SceneInspectionTableItemWarningSigns>();
    
    /**
     * 整改列表
     */
    @Transient
    private List<ReformItemBasic> reformList = new ArrayList<ReformItemBasic>();

    private static final long serialVersionUID = 1L;
    
    @Transient
    private String updateDateStr;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取检查编号
     *
     * @return inspection_no - 检查编号
     */
    public String getInspectionNo() {
        return inspectionNo;
    }

    /**
     * 设置检查编号
     *
     * @param inspectionNo 检查编号
     */
    public void setInspectionNo(String inspectionNo) {
        this.inspectionNo = inspectionNo == null ? null : inspectionNo.trim();
    }

    /**
     * 获取实际检查时间
     *
     * @return inspection_actual_time - 实际检查时间
     */
    public Date getInspectionActualTime() {
        return inspectionActualTime;
    }

    /**
     * 设置实际检查时间
     *
     * @param inspectionActualTime 实际检查时间
     */
    public void setInspectionActualTime(Date inspectionActualTime) {
        this.inspectionActualTime = inspectionActualTime;
    }

    /**
     * 获取检查类型（综合性，专业性，……）
     *
     * @return inspection_type - 检查类型（综合性，专业性，……）
     */
    public Byte getInspectionType() {
        return inspectionType;
    }

    /**
     * 设置检查类型（综合性，专业性，……）
     *
     * @param inspectionType 检查类型（综合性，专业性，……）
     */
    public void setInspectionType(Byte inspectionType) {
        this.inspectionType = inspectionType;
    }

    /**
     * 获取检查范围（区域ID，以逗号分隔）
     *
     * @return inspection_ranges - 检查范围（区域ID，以逗号分隔）
     */
    public String getInspectionRanges() {
        return inspectionRanges;
    }

    /**
     * 设置检查范围（区域ID，以逗号分隔）
     *
     * @param inspectionRanges 检查范围（区域ID，以逗号分隔）
     */
    public void setInspectionRanges(String inspectionRanges) {
        this.inspectionRanges = inspectionRanges == null ? null : inspectionRanges.trim();
    }

    /**
     * 获取检查负责人
     *
     * @return inspection_director - 检查负责人
     */
    public Long getInspectionDirector() {
        return inspectionDirector;
    }

    /**
     * 设置检查负责人
     *
     * @param inspectionDirector 检查负责人
     */
    public void setInspectionDirector(Long inspectionDirector) {
        this.inspectionDirector = inspectionDirector;
    }

    /**
     * 获取检查负责人姓名（冗余）
     *
     * @return inspection_director_name - 检查负责人姓名（冗余）
     */
    public String getInspectionDirectorName() {
        return inspectionDirectorName;
    }

    /**
     * 设置检查负责人姓名（冗余）
     *
     * @param inspectionDirectorName 检查负责人姓名（冗余）
     */
    public void setInspectionDirectorName(String inspectionDirectorName) {
        this.inspectionDirectorName = inspectionDirectorName == null ? null : inspectionDirectorName.trim();
    }

    /**
     * 获取检查协作人（员工ID，以逗号分隔）
     *
     * @return inspection_collaborator - 检查协作人（员工ID，以逗号分隔）
     */
    public String getInspectionCollaborator() {
        return inspectionCollaborator;
    }

    /**
     * 设置检查协作人（员工ID，以逗号分隔）
     *
     * @param inspectionCollaborator 检查协作人（员工ID，以逗号分隔）
     */
    public void setInspectionCollaborator(String inspectionCollaborator) {
        this.inspectionCollaborator = inspectionCollaborator == null ? null : inspectionCollaborator.trim();
    }

    /**
     * 获取检查协作人姓名（冗余）
     *
     * @return inspection_collaborator_name - 检查协作人姓名（冗余）
     */
    public String getInspectionCollaboratorName() {
        return inspectionCollaboratorName;
    }

    /**
     * 设置检查协作人姓名（冗余）
     *
     * @param inspectionCollaboratorName 检查协作人姓名（冗余）
     */
    public void setInspectionCollaboratorName(String inspectionCollaboratorName) {
        this.inspectionCollaboratorName = inspectionCollaboratorName == null ? null : inspectionCollaboratorName.trim();
    }

    /**
     * 获取纸质检查表存放位置
     *
     * @return inspection_table_paper_store_place - 纸质检查表存放位置
     */
    public String getInspectionTablePaperStorePlace() {
        return inspectionTablePaperStorePlace;
    }

    /**
     * 设置纸质检查表存放位置
     *
     * @param inspectionTablePaperStorePlace 纸质检查表存放位置
     */
    public void setInspectionTablePaperStorePlace(String inspectionTablePaperStorePlace) {
        this.inspectionTablePaperStorePlace = inspectionTablePaperStorePlace == null ? null : inspectionTablePaperStorePlace.trim();
    }

    /**
     * 获取状态（1、存草稿；2、完成)
     *
     * @return status - 状态（1、存草稿；2、完成)
     */
    public Byte getStatus() {
        return status;
    }

    /**
     * 设置状态（1、存草稿；2、完成)
     *
     * @param status 状态（1、存草稿；2、完成)
     */
    public void setStatus(Byte status) {
        this.status = status;
    }

    /**
     * 获取检查内容（检查表ID，以逗号分隔）
     *
     * @return inspection_table - 检查内容（检查表ID，以逗号分隔）
     */
    public String getInspectionTable() {
        return inspectionTable;
    }

    /**
     * 设置检查内容（检查表ID，以逗号分隔）
     *
     * @param inspectionTable 检查内容（检查表ID，以逗号分隔）
     */
    public void setInspectionTable(String inspectionTable) {
        this.inspectionTable = inspectionTable == null ? null : inspectionTable.trim();
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

	public String getWorkName() {
		return workName;
	}

	public void setWorkName(String workName) {
		this.workName = workName;
	}

	public String getInspectionType1() {
		return inspectionType1;
	}

	public void setInspectionType1(String inspectionType1) {
		this.inspectionType1 = inspectionType1;
	}

	public String getSupervisoryOpinionFiles() {
		return supervisoryOpinionFiles;
	}

	public void setSupervisoryOpinionFiles(String supervisoryOpinionFiles) {
		this.supervisoryOpinionFiles = supervisoryOpinionFiles;
	}

	public String getOtherFiles() {
		return otherFiles;
	}

	public void setOtherFiles(String otherFiles) {
		this.otherFiles = otherFiles;
	}

	public List<SceneInspectionTableItemCustomCurrent> getItemCustomList() {
		return itemCustomList;
	}

	public void setItemCustomList(List<SceneInspectionTableItemCustomCurrent> itemCustomList) {
		this.itemCustomList = itemCustomList;
	}

	public List<SceneInspectionTableItemDevice> getItemDeviceList() {
		return itemDeviceList;
	}

	public void setItemDeviceList(List<SceneInspectionTableItemDevice> itemDeviceList) {
		this.itemDeviceList = itemDeviceList;
	}

	public List<SceneInspectionTableItemReform> getItemReformList() {
		return itemReformList;
	}

	public void setItemReformList(List<SceneInspectionTableItemReform> itemReformList) {
		this.itemReformList = itemReformList;
	}

	public List<SceneInspectionTableItemWarningSigns> getItemWarningSingsList() {
		return itemWarningSingsList;
	}

	public void setItemWarningSingsList(List<SceneInspectionTableItemWarningSigns> itemWarningSingsList) {
		this.itemWarningSingsList = itemWarningSingsList;
	}

	public String getInspectionRangesName() {
		return inspectionRangesName;
	}

	public void setInspectionRangesName(String inspectionRangesName) {
		this.inspectionRangesName = inspectionRangesName;
	}

	public String getInspectionTypeName() {
		return inspectionTypeName;
	}

	public void setInspectionTypeName(String inspectionTypeName) {
		this.inspectionTypeName = inspectionTypeName;
	}

	public String getStatusName() {
		return statusName;
	}

	public void setStatusName(String statusName) {
		this.statusName = statusName;
	}

	public String getInspectionTableName() {
		return inspectionTableName;
	}

	public void setInspectionTableName(String inspectionTableName) {
		this.inspectionTableName = inspectionTableName;
	}

	public List<ReformItemBasic> getReformList() {
		return reformList;
	}

	public void setReformList(List<ReformItemBasic> reformList) {
		this.reformList = reformList;
	}

	public String getSuperDepartment() {
		return superDepartment;
	}

	public void setSuperDepartment(String superDepartment) {
		this.superDepartment = superDepartment;
	}

	public Byte getResult() {
		return result;
	}

	public void setResult(Byte result) {
		this.result = result;
	}

	public String getSupervisoryOpinionFilesName() {
		return supervisoryOpinionFilesName;
	}

	public void setSupervisoryOpinionFilesName(String supervisoryOpinionFilesName) {
		this.supervisoryOpinionFilesName = supervisoryOpinionFilesName;
	}
	public String getUpdateDateStr() {
		if(this.updateDate!=null){
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
			this.updateDateStr = sdf.format(this.updateDate);
		}
		return updateDateStr;
	}

	public void setUpdateDateStr(String updateDateStr) {
		this.updateDateStr = updateDateStr;
	}

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
}