package cn.smarthse.modules.health.entity.work.reform.vo;

import cn.smarthse.modules.health.enums.reform.ReformGenerationSourceChildEnum;
import lombok.Data;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * 风险列表结果
 *
 * @author ShenZQ
 * @since 2023/3/13 16:41
 */
@Data
public class RiskListItemDataVo implements Serializable {

    private static final long serialVersionUID = -1414867247994712180L;

    private Long id;
    /**
     * 整改项编号
     */
    private String reformItemSn;
    /**
     * 状态
     */
    private Byte status;
    /**
     * 业务总状态
     */
    private Byte businessStatus;
    /**
     * 整改是否超期
     */
    private Boolean overdueStatus;
    /**
     * 验收是否超期
     */
    private Boolean accOverdueStatus;
    /**
     * 生成来源 见枚举ReformGenerationSourceEnum
     */
    private Byte generationSource;

    /**
     * 生成的整改项类型generationSource的子项
     * @see  ReformGenerationSourceChildEnum
     */
    private Byte reformItemSourceType;

    /**
     * 风险来源
     */
    private Byte reformItemSource;
    /*
        主体履责 1 --> 防治责任自查 1
        服务管家 2 --> 第三方托管核查 2
        智能评估 3 --> 职业健康体检、职业病危害因素检测 3、4
        乡镇协管 4 --> 乡镇协管 11
        在线监测监控 5 --> 在线监测、在线监控 5、6
     */
    private Byte source;
    /**
     * 整改项名称
     */
    private String name;
    /**
     * 整改负责人姓名
     */
    private String reformDirectorName;
    /**
     * 验收负责人姓名
     */
    private String acceptanceDirectorName;
    /**
     * 发现时间
     */
    private Date findTime;

    private String findTimeStr;
    /**
     * 实际完成时间
     */
    private Date actualFinishTime;

    private String actualFinishTimeStr;
    /**
     * 验收时间
     */
    private Date acceptanceDate;

    private String acceptanceDateStr;

    /**
     * 最后更新时间
     */
    private Date updateTime;

    private String updateTimeStr;

    /**
     * 分级
     */
    private String reformItemLevel;

    /**
     * 是否已经完成
     */
    private Boolean isReformFinished;

    private Byte warningState;

    public void setFindTime(Date findTime) {
        if (findTime!=null) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            this.findTimeStr = format.format(findTime);
            this.findTime = findTime;
        }
    }

    public void setActualFinishTime(Date actualFinishTime) {
        if (actualFinishTime!=null) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            this.actualFinishTimeStr = format.format(actualFinishTime);
            this.actualFinishTime = actualFinishTime;
        }
    }

    public void setAcceptanceDate(Date acceptanceDate) {
        if (acceptanceDate!=null) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            this.acceptanceDateStr = format.format(acceptanceDate);
            this.acceptanceDate = acceptanceDate;
        }
    }
}
