package cn.smarthse.modules.health.entity.work.reform.vo;

import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.enums.reform.ReformGenerationSourceEnum;
import cn.smarthse.modules.health.enums.reform.ReformSourceLiteEnum;
import lombok.Data;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * 整改基础信息
 * @author 吴嘉诚
 * @date 2023/3/15
 * @desc
 */
public @Data
class RiskInfoDataVo implements Serializable {

    private Long id;

    private Long cid;

    private String name;        //整改名称

    private String reformItemSn;      //风险编号

    private String finderName;      //风险发现人

    private Date findTime;

    private String findTimeStr;     //发现时间Str

    private String reformItemSources;      //风险来源（V3221 变更为多数据来源）

    private String reformItemSourcesStr;

    private String reformItemPositionName;        //对应检查工作

    private String description;        //风险描述

    private Long reformItemSourceId;

    private Byte generationSource;

    private String generationSourceStr;

    public void setGenerationSource(Byte generationSource) {
        this.generationSourceStr = ReformGenerationSourceEnum.getNameByValue(generationSource);
        this.generationSource = generationSource;
    }

    public void setFindTime(Date findTime) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        this.findTimeStr = format.format(findTime);
        this.findTime = findTime;
    }

    public void setReformItemSources(String reformItemSources) {
        if (StringUtils.isNotEmpty(reformItemSources)) {
            String[] split = reformItemSources.split(",");
            StringBuilder gs = new StringBuilder();
            for (String reformItemSource : split) {
                gs.append(ReformSourceLiteEnum.getSourceNameByValue(Byte.valueOf(reformItemSource)));
                gs.append(",");
            }
            this.reformItemSourcesStr = gs.substring(0, gs.length() - 1);
        }
        this.reformItemSources = reformItemSources;
    }

}
