package cn.smarthse.modules.health.entity.work.reform.vo;

import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import lombok.Data;

import java.io.Serializable;
import java.util.List;


/**
 * 危害因素检测整改项列表对象
 * 《》
 * 
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author Horsy(何世壹) [hsy@smarthse.cn]
 * @since 2017年8月15日-上午9:39:16
 */
public @Data
class ReformItemListVo implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	/**
	 * 整改项ID
	 */
	private Long reformItemId;

	private Long cid;


	private Long sourceId;


	private String sourceName;
	
	/**
	 * 整改项编号
	 */
	private String reformItemSn;
	
	/**
	 * 整改项名称
	 */
	private String reformItemName;
	
	/**
     * 整改项描述
     */
    private String description;
	
	/**
	 * 整改来源
	 */
	private String reformItemSource;
	
	/**
	 * 要求完成时间（最新整改与验收信息的要求完成时间）
	 */
	private String requireFinishTime;
	
	/**
	 * 更新时间（最新整改与验收信息的更新时间）
	 */
	private String updateTime;
	
	/**
	 * 整改项分级
	 */
	private String reformItemLevel;
	
	/**
	 * 整改项分类
	 */
	private String reformItemType;
	
	/**
	 * 整改负责人（最新整改与验收信息的整改负责人）
	 */
	private String reformDirector;
	
	/**
	 * 整改位置
	 */
	private String reformItemPosition;
	
	/**
	 * 整改方案（有、无）（最新整改与验收信息的整改方案）
	 */
	private String reformSolution;
	
	/**
	 * 整改方案文件列表
	 */
	private List<SysFileModel> solutionFiles;
	
	/**
	 * 验收负责人
	 */
	private String acceptanceDirector;
	
	/**
	 * 实际完成时间
	 */
	private String actualFinishTime;

	/**
	 * 验收时间
	 */
	private String acceptanceTime;
	
	/**
	 * 发现时间
	 */
	private String findTime;
	
	/**
	 * 是否整改完成
	 */
	private String isReformFinished;
	
	/**
	 * 编辑者
	 */
	private Long editor;
	
	/**
	 * 是否走流程
	 */
	private Boolean isProcess;

	private  Byte status; // 状态 5：完成 其他：未完成

	private  Byte businessStatus;

	private String comName; //企业名称
	//是否自动生成
	private Boolean isAutoGeneration;

	private  Byte generationSource;

	private Integer accNum;


}
