package cn.smarthse.modules.health.entity.work.reform.vo;

import cn.smarthse.modules.health.enums.sys.StatusEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

public @Data
class ReformItemFinishedSeniorSearch implements Serializable{
	

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	/**
	 * 企业ID
	 */
	private Long cid;
	
	/**
	 * 整改名称
	 */
	private String reformItemName;
	
	/**
	 * 整改名称
	 */
	public final static String REFORM_ITEM_NAME="reformItemName";
	
	/**
	 * 整改分级
	 */
	private Byte reformItemLevel;
	
	/**
	 * 整改分级
	 */
	public final static String REFORM_ITEM_LEVEL="reformItemLevel";
	
	/**
	 * 整改来源
	 */
	private Byte reformItemSource;

	/**
	 * 隐患分类
	 */
	private Byte reformItemType;


	/**
	 * 状态（0、草稿；1、完成，待整改；2、被退回；3完成)
	 */
	private Byte status;

	/**
	 * 状态（0、草稿；1、完成，待整改；2、被退回；3完成)
	 */
	private Byte urlStatus;
	
	/**
	 * 整改来源
	 */
	public final static String REFORM_ITEM_SOURCE="reformItemSource";
	
	/**
	 * 整改负责人
	 */
	private Long reformDirector;
	
	/**
	 * 整改负责人
	 */
	public final static String REFORM_DIRECTOR="reformDirector";
	
	/**
	 * 验收负责人
	 */
	private Long acceptanceDirector;
	
	/**
	 * 危害因素检测状态
	 */
	private Byte harmFactorStatus;
	
	/**
	 * 危害因素检测状态
	 */
	public final static String HARM_FACTOR_STATUS = "harmFactorStatus";
	/**
	 * 危害因素检测类型
	 */
	private Byte harmFactorType;
	
	/**
	 * 验收负责人
	 */
	public final static String ACCEPTANCE_DIRECTOR="acceptanceDirector";
	
	/**
	 * 要求完成时间开始
	 */
	public Date requireFinishTimeStart;
	
	/**
	 * 要求完成时间结束
	 */
	public Date requireFinishTimeEnd;
	
	/**
	 * 要求完成时间(开始）
	 */
	public final static String REQUIRE_FINISH_TIME_START="requireFinishTimeStart";
	
	/**
	 * 要求完成时间(结束）
	 */
	public final static String REQUIRE_FINISH_TIME_END="requireFinishTimeEnd";

	/**
	 * 生成来源类型
	 */
	private Byte generationType;
	
	private Byte businessStatus = StatusEnum.finished.getValue();

	private Integer overTime;


}
