package cn.smarthse.modules.health.entity.work.reform.vo;

import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.health.entity.work.reform.ReformItemBasic;
import lombok.Data;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Data
public class ReformAcceptanceRecordVo implements java.io.Serializable{

    private static final long serialVersionUID = -1L;

    private ReformItemBasic dbReform;

    /**  整改项属性 **/
    private Long id;

    //整改负责人
    private String reformDirector;

    //整改期限
    private Date requireFinishTime;

    /**
     * 整改措施
     */
    private String reformMeasure;

    /**
     * 检测超标整改措施是否是历史数据：如果没有历史数据都默认显示新的
     */
    private Boolean checkMeasureIsOld = true;

    /**
     * 整改项附件（作证材料）
     */
    private String reformItemFiles;

    private List<SysFileModel> reformItemFileList;

    private List<SysFileModel> reformFinishedFilesList;


    /** 验收属性 **/

    /**
     * 验收负责人姓名（冗余）
     */
    private String acceptanceDirectorName;

    /**
     * 验收时间
     */
    private Date acceptanceDate;


    /**
     * 验收相关资料（作证材料）
     */
    private String acceptanceFiles;
    private List<SysFileModel> acceptanceFileList;

    /**
     * 验收结论
     */
    private Byte acceptanceResult;

    /**
     * 验收结论说明
     */
    private String acceptanceResultExplain;

    /**
     * 状态
     */
    private Byte status;


    /**
     * 实际完成时间
     */
    private Date actualFinishTime;

    /**
     * 发现时间
     */
    private Date findTime;

    private String findTimeStr;

    private Byte dealMeasure;

    private String dealMeasureName;

    private Long thirdOrgId;

    /**
     * 诊断/体检机构
     */
    private String thirdOrgName;

    private String dealTimeBegin;

    private String reformItemSourceId;

    /**
     * 整改方案资料(疑似职业病添加必填项)
     */
    private String reformProgrammeFiles;
    /**
     * 整改方案文件(疑似职业病添加必填项)
     */
    private List<SysFileModel> reformSolutionFilesList;

    /**
     * 体检作证材料整改方案
     * key-》那个方案 value-》不为空则是具体原因，为空就可以勾选
     * （1，无）
     * （1，最近一次检测结果包含除放射性危害因素之外的危害因素）
     */
    private Map<String,String> tjReformSolutionMap;

    private String tjReformSolution;

    private Date nextStartDate;

    public void setFindTime(Date findTime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        this.findTimeStr = sdf.format(findTime);
        this.findTime = findTime;
    }

    public String getActualFinishTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return Objects.nonNull(actualFinishTime)?sdf.format(actualFinishTime):"";
    }

    public String getAcceptanceResult() {

        return Objects.nonNull(acceptanceResult)?(acceptanceResult==1?"整改通过":"整改未通过"):"";
    }

    public String getRequireFinishTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

        return Objects.nonNull(requireFinishTime)?sdf.format(requireFinishTime):"";
    }

    public String getAcceptanceDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return Objects.nonNull(acceptanceDate)?sdf.format(acceptanceDate):"";
    }
}
