package cn.smarthse.modules.health.entity.work.reform.vo;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * 东阳区域风险化解情况和巡查情况(DyAreaRiskCompletion)Vo
 *
 * @author zhangxu
 * @since 2024-05-08
 */
@Data
@Accessors(chain = true)
public class DyAreaRiskCompletionVo implements Serializable {

    //属性名后缀1，2，0分别对应营业状态正常，暂停，关闭，没加后缀的是总数

    private Integer idx;

    /**
     * 区域id
     */
    private Long areaId;

    /**
     * 区域名称
     */
    private String areaName;

    /**
     * 辖区企业数量
     */
    private Integer comNum;
    private Integer comNum1;
    private Integer comNum2;
    private Integer comNum0;

    /**
     * 风险总数
     */
    private Integer riskTotalNum;

    /**
     * 已化解风险总数
     */
    private Integer riskCompleted;

    /**
     * 八项风险全部完成企业数
     */
    private Integer comAllCompleted;
    private Integer comAllCompleted1;
    private Integer comAllCompleted2;
    private Integer comAllCompleted0;

    /**
     * 企业全部风险化解率
     */
    private String comRiskNumRate;

    /**
     * 已巡查企业数
     */
    private Integer comPatrolNum;
    private Integer comPatrolNum1;
    private Integer comPatrolNum2;
    private Integer comPatrolNum0;

    /**
     * 巡查风险已化解企业数
     */
    private Integer comPatrolRiskDefuseNum;
    private Integer comPatrolRiskDefuseNum1;
    private Integer comPatrolRiskDefuseNum2;
    private Integer comPatrolRiskDefuseNum0;

    /**
     * 巡查覆盖率
     */
    private String comPatrolRate;

    /**
     * 巡查化解率
     */
    private String comPatrolRiskDefuseRate;

    /**
     * 服务指导企业数
     */
    private Integer comGuidanceNum;
    private Integer comGuidanceNum1;
    private Integer comGuidanceNum2;
    private Integer comGuidanceNum0;

    /**
     * 服务指导企业次数
     */
    private Integer comGuidanceTimeNum;

    /**
     * 本日化解风险数
     */
    private Integer riskNumThisDay;

    /**
     * 本月化解风险数
     */
    private Integer riskNumThisMonth;

    /**
     * 更新时间
     */
    private Date updateDate;
    private String updateDateStr;
}

